/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneTopNColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneTopNColumns
extends BaseRuleTest {
    private static final long COUNT = 10L;

    public TestPruneTopNColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneTopNColumns()).on(p -> this.buildProjectedTopN((PlanBuilder)p, variable -> variable.getName().equals("b"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("b", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testAllInputsRereferenced() {
        this.tester().assertThat((Rule)new PruneTopNColumns()).on(p -> this.buildProjectedTopN((PlanBuilder)p, variable -> variable.getName().equals("a"))).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneTopNColumns()).on(p -> this.buildProjectedTopN((PlanBuilder)p, (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).doesNotFire();
    }

    private ProjectNode buildProjectedTopN(PlanBuilder planBuilder, Predicate<VariableReferenceExpression> projectionTopN) {
        VariableReferenceExpression a = planBuilder.variable("a");
        VariableReferenceExpression b = planBuilder.variable("b");
        return planBuilder.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((Collection)((Collection)ImmutableList.of((Object)a, (Object)b).stream().filter(projectionTopN).collect(ImmutableSet.toImmutableSet()))), (PlanNode)planBuilder.topN(10L, (List<VariableReferenceExpression>)ImmutableList.of((Object)b), (PlanNode)planBuilder.values(a, b)));
    }
}

