/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneWindowColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneWindowColumns
extends BaseRuleTest {
    private static final String FUNCTION_NAME = "min";
    private static final FunctionHandle FUNCTION_HANDLE = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("min", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final List<String> inputSymbolNameList = ImmutableList.of((Object)"orderKey", (Object)"partitionKey", (Object)"hash", (Object)"startValue1", (Object)"startValue2", (Object)"endValue1", (Object)"endValue2", (Object)"input1", (Object)"input2", (Object)"unused");
    private static final Set<String> inputSymbolNameSet = ImmutableSet.copyOf(inputSymbolNameList);
    private static final ExpectedValueProvider<WindowNode.Frame> frameProvider1 = PlanMatchPattern.windowFrame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.of("startValue1"), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.of("endValue1"));
    private static final ExpectedValueProvider<WindowNode.Frame> frameProvider2 = PlanMatchPattern.windowFrame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.of("startValue2"), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.of("endValue2"));

    public TestPruneWindowColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testWindowNotNeeded() {
        this.tester().assertThat((Rule)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> inputSymbolNameSet.contains(symbol.getName()), (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject(Maps.asMap(inputSymbolNameSet, PlanMatchPattern::expression), PlanMatchPattern.values(inputSymbolNameList)));
    }

    @Test
    public void testOneFunctionNotNeeded() {
        this.tester().assertThat((Rule)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> symbol.getName().equals("output2") || symbol.getName().equals("unused"), (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output2", (Object)PlanMatchPattern.expression("output2"), (Object)"unused", (Object)PlanMatchPattern.expression("unused")), PlanMatchPattern.window(windowBuilder -> windowBuilder.prePartitionedInputs((Set<String>)ImmutableSet.of()).specification((List<String>)ImmutableList.of((Object)"partitionKey"), (List<String>)ImmutableList.of((Object)"orderKey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"orderKey", (Object)SortOrder.ASC_NULLS_FIRST)).preSortedOrderPrefix(0).addFunction("output2", PlanMatchPattern.functionCall(FUNCTION_NAME, (List<String>)ImmutableList.of((Object)"input2")), FUNCTION_HANDLE, frameProvider2).hashSymbol("hash"), PlanMatchPattern.strictProject(Maps.asMap((Set)Sets.difference(inputSymbolNameSet, (Set)ImmutableSet.of((Object)"input1", (Object)"startValue1", (Object)"endValue1")), PlanMatchPattern::expression), PlanMatchPattern.values(inputSymbolNameList)))));
    }

    @Test
    public void testAllColumnsNeeded() {
        this.tester().assertThat((Rule)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue(), (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).doesNotFire();
    }

    @Test
    public void testUsedInputsNotNeeded() {
        this.tester().assertThat((Rule)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> !inputSymbolNameSet.contains(symbol.getName()), symbol -> !symbol.getName().equals("unused"))).doesNotFire();
    }

    @Test
    public void testUnusedInputNotNeeded() {
        this.tester().assertThat((Rule)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> !inputSymbolNameSet.contains(symbol.getName()), (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output1", (Object)PlanMatchPattern.expression("output1"), (Object)"output2", (Object)PlanMatchPattern.expression("output2")), PlanMatchPattern.window(windowBuilder -> windowBuilder.prePartitionedInputs((Set<String>)ImmutableSet.of()).specification((List<String>)ImmutableList.of((Object)"partitionKey"), (List<String>)ImmutableList.of((Object)"orderKey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"orderKey", (Object)SortOrder.ASC_NULLS_FIRST)).preSortedOrderPrefix(0).addFunction("output1", PlanMatchPattern.functionCall(FUNCTION_NAME, (List<String>)ImmutableList.of((Object)"input1")), FUNCTION_HANDLE, frameProvider1).addFunction("output2", PlanMatchPattern.functionCall(FUNCTION_NAME, (List<String>)ImmutableList.of((Object)"input2")), FUNCTION_HANDLE, frameProvider2).hashSymbol("hash"), PlanMatchPattern.strictProject(Maps.asMap((Set)Sets.filter(inputSymbolNameSet, symbolName -> !symbolName.equals("unused")), PlanMatchPattern::expression), PlanMatchPattern.values(inputSymbolNameList)))));
    }

    private static PlanNode buildProjectedWindow(PlanBuilder p, Predicate<VariableReferenceExpression> projectionFilter, Predicate<VariableReferenceExpression> sourceFilter) {
        VariableReferenceExpression orderKey = p.variable("orderKey");
        VariableReferenceExpression partitionKey = p.variable("partitionKey");
        VariableReferenceExpression hash = p.variable("hash");
        VariableReferenceExpression startValue1 = p.variable("startValue1");
        VariableReferenceExpression startValue2 = p.variable("startValue2");
        VariableReferenceExpression endValue1 = p.variable("endValue1");
        VariableReferenceExpression endValue2 = p.variable("endValue2");
        VariableReferenceExpression input1 = p.variable("input1");
        VariableReferenceExpression input2 = p.variable("input2");
        VariableReferenceExpression unused = p.variable("unused");
        VariableReferenceExpression output1 = p.variable("output1");
        VariableReferenceExpression output2 = p.variable("output2");
        ImmutableList inputs = ImmutableList.of((Object)orderKey, (Object)partitionKey, (Object)hash, (Object)startValue1, (Object)startValue2, (Object)endValue1, (Object)endValue2, (Object)input1, (Object)input2, (Object)unused);
        ImmutableList outputs = ImmutableList.builder().addAll((Iterable)inputs).add((Object[])new VariableReferenceExpression[]{output1, output2}).build();
        List filteredInputs = (List)inputs.stream().filter(sourceFilter).collect(ImmutableList.toImmutableList());
        return p.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((Collection)((Collection)outputs.stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)partitionKey), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Ordering(orderKey, SortOrder.ASC_NULLS_FIRST))))), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)output1, (Object)new WindowNode.Function(Expressions.call((String)FUNCTION_NAME, (FunctionHandle)FUNCTION_HANDLE, (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{input1}), new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.of(startValue1), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.of(endValue1), Optional.of(new SymbolReference(startValue1.getName())).map(Expression::toString), Optional.of(new SymbolReference(endValue2.getName())).map(Expression::toString)), false), (Object)output2, (Object)new WindowNode.Function(Expressions.call((String)FUNCTION_NAME, (FunctionHandle)FUNCTION_HANDLE, (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{input2}), new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.of(startValue2), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.of(endValue2), Optional.of(new SymbolReference(startValue2.getName())).map(Expression::toString), Optional.of(new SymbolReference(endValue2.getName())).map(Expression::toString)), false)), hash, (PlanNode)p.values(filteredInputs, (List<List<RowExpression>>)ImmutableList.of())));
    }
}

