/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushProjectionThroughUnion
extends BaseRuleTest {
    public TestPushProjectionThroughUnion() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new PushProjectionThroughUnion()).on(p -> p.project(PlanBuilder.assignment(p.variable("x"), (Expression)new LongLiteral("3")), (PlanNode)p.values(p.variable("a")))).doesNotFire();
    }

    @Test
    public void test() {
        FunctionResolution functionResolution = new FunctionResolution(this.tester().getMetadata().getFunctionAndTypeManager());
        this.tester().assertThat((Rule)new PushProjectionThroughUnion()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            return p.project(PlanBuilder.assignment(p.variable("c_times_3"), (RowExpression)Expressions.call((String)"c * 3", (FunctionHandle)functionResolution.arithmeticFunction(OperatorType.MULTIPLY, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{c, Expressions.constant((Object)3L, (Type)BigintType.BIGINT)})), (PlanNode)p.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(a), (Object)p.values(b))));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_times_3", (Object)PlanMatchPattern.expression("a * 3")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_times_3", (Object)PlanMatchPattern.expression("b * 3")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b")))).withNumberOfOutputColumns(1).withAlias("a_times_3").withAlias("b_times_3"));
    }
}

