/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.execution.thrift.ThriftSqlFunctionExecutor;
import com.facebook.presto.functionNamespace.testing.InMemoryFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.testing.SqlInvokedFunctionTestUtils;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RewriteFilterWithExternalFunctionToProject;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRewriteFilterWithExternalFunctionToProject
extends BaseRuleTest {
    private static final QualifiedFunctionName REMOTE_FOO = QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"remote_foo");
    private static final RoutineCharacteristics.Language JAVA = new RoutineCharacteristics.Language("java");
    private static final SqlInvokedFunction FUNCTION_REMOTE_FOO = new SqlInvokedFunction(REMOTE_FOO, (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "remote_foo(x)", RoutineCharacteristics.builder().setLanguage(JAVA).setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "", Optional.empty());

    public TestRewriteFilterWithExternalFunctionToProject() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setup() {
        FunctionAndTypeManager functionAndTypeManager = this.getFunctionManager();
        functionAndTypeManager.addFunctionNamespace("unittest", (FunctionNamespaceManager)new InMemoryFunctionNamespaceManager("unittest", new SqlFunctionExecutors((Map)ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL, (Object)JAVA, (Object)FunctionImplementationType.THRIFT), new ThriftSqlFunctionExecutor(null)), new SqlInvokedFunctionNamespaceManagerConfig().setSupportedFunctionLanguages("sql,java")));
        functionAndTypeManager.createFunction(SqlInvokedFunctionTestUtils.FUNCTION_TANGENT, true);
        functionAndTypeManager.createFunction(FUNCTION_REMOTE_FOO, true);
    }

    @Test
    public void testNoExternalFunctionInFilter() {
        this.tester().assertThat((Rule)new RewriteFilterWithExternalFunctionToProject(this.getFunctionManager())).on(p -> {
            p.variable("x", (Type)IntegerType.INTEGER);
            return p.filter(p.rowExpression("unittest.memory.tangent(x) > 1"), (PlanNode)p.values(p.variable("x", (Type)IntegerType.INTEGER)));
        }).doesNotFire();
    }

    @Test
    public void testFilterWithExternalFunctionRewrite() {
        this.tester().assertThat((Rule)new RewriteFilterWithExternalFunctionToProject(this.getFunctionManager())).on(p -> {
            p.variable("x", (Type)IntegerType.INTEGER);
            return p.filter(p.rowExpression("unittest.memory.remote_foo(x) > 1"), (PlanNode)p.values(p.variable("x", (Type)IntegerType.INTEGER)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("x")), PlanMatchPattern.filter("greater_than", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"greater_than", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo(x) > 1"), (Object)"x", (Object)PlanMatchPattern.expression("x")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0))))));
    }
}

