/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyExpressions;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimplifyExpressions {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final LiteralEncoder LITERAL_ENCODER = new LiteralEncoder(METADATA.getBlockEncodingSerde());
    private static final Map<String, Type> TYPES = Streams.concat((Stream[])new Stream[]{Stream.of("A", "B", "C", "D", "E", "F", "I", "V", "X", "Y", "Z"), IntStream.range(1, 61).boxed().map(i -> String.format("A%s", i))}).collect(Collectors.toMap(Function.identity(), string -> BooleanType.BOOLEAN));

    @Test
    public void testPushesDownNegations() {
        TestSimplifyExpressions.assertSimplifies("NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT X", "X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT (X > Y)", "X <= Y");
        TestSimplifyExpressions.assertSimplifies("NOT (X > (NOT NOT Y))", "X <= Y");
        TestSimplifyExpressions.assertSimplifies("X > (NOT NOT Y)", "X > Y");
        TestSimplifyExpressions.assertSimplifies("NOT (X AND Y AND (NOT (Z OR V)))", "(NOT X) OR (NOT Y) OR (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (NOT (Z OR V)))", "(NOT X) AND (NOT Y) AND (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (Z OR V))", "(NOT X) AND (NOT Y) AND ((NOT Z) AND (NOT V))");
        TestSimplifyExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)");
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyExpressions.assertSimplifies("TRUE", "TRUE");
        TestSimplifyExpressions.assertSimplifies("IF(X, X, Y)", "IF(X, X, Y)");
        TestSimplifyExpressions.assertSimplifies("X AND Y", "X AND Y");
        TestSimplifyExpressions.assertSimplifies("X OR Y", "X OR Y");
        TestSimplifyExpressions.assertSimplifies("X AND X", "X");
        TestSimplifyExpressions.assertSimplifies("X OR X", "X");
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Y)", "X OR Y");
        TestSimplifyExpressions.assertSimplifies("(A AND V) OR V", "V");
        TestSimplifyExpressions.assertSimplifies("(A OR V) AND V", "V");
        TestSimplifyExpressions.assertSimplifies("(A OR B OR C) AND (A OR B)", "A OR B");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (A AND B AND C)", "A AND B");
        TestSimplifyExpressions.assertSimplifies("I = ((A OR B) AND (A OR B OR C))", "I = (A OR B)");
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Z)", "(X OR Y) AND (X OR Z)");
        TestSimplifyExpressions.assertSimplifies("(X AND Y AND V) OR (X AND Y AND Z)", "(X AND Y) AND (V OR Z)");
        TestSimplifyExpressions.assertSimplifies("((X OR Y OR V) AND (X OR Y OR Z)) = I", "((X OR Y) OR (V AND Z)) = I");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND V) OR ((X OR V) AND V)", "V");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND X) OR ((X OR V) AND V)", "X OR V");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND Z) OR ((X OR V) AND V)", "(X OR V) AND (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("X AND ((Y AND Z) OR (Y AND V) OR (Y AND X))", "X AND Y AND (Z OR V OR X)", "X AND Y");
        TestSimplifyExpressions.assertSimplifies("(A AND B AND C AND D) OR (A AND B AND E) OR (A AND F)", "A AND ((B AND C AND D) OR (B AND E) OR F)");
        TestSimplifyExpressions.assertSimplifies("((A AND B) OR (A AND C)) AND D", "A AND (B OR C) AND D");
        TestSimplifyExpressions.assertSimplifies("((A OR B) AND (A OR C)) OR D", "(A OR B OR D) AND (A OR C OR D)");
        TestSimplifyExpressions.assertSimplifies("(((A AND B) OR (A AND C)) AND D) OR E", "(A OR E) AND (B OR C OR E) AND (D OR E)");
        TestSimplifyExpressions.assertSimplifies("(((A OR B) AND (A OR C)) OR D) AND E", "(A OR (B AND C) OR D) AND E");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D)", "(A OR C) AND (A OR D) AND (B OR C) AND (B OR D)");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D) OR (E AND F)", "(A AND B) OR (C AND D) OR (E AND F)");
        TestSimplifyExpressions.assertSimplifies("(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)", "(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)");
    }

    private static void assertSimplifies(String expression, String expected) {
        TestSimplifyExpressions.assertSimplifies(expression, expected, null);
    }

    private static void assertSimplifies(String expression, String expected, String rowExpressionExpected) {
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression));
        Expression expectedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected));
        Expression rewritten = SimplifyExpressions.rewrite((Expression)actualExpression, (Session)SessionTestUtils.TEST_SESSION, (PlanVariableAllocator)new PlanVariableAllocator(TestSimplifyExpressions.booleanVariablesFor(actualExpression)), (Metadata)METADATA, (LiteralEncoder)LITERAL_ENCODER, (SqlParser)SQL_PARSER);
        Assert.assertEquals((Object)TestSimplifyExpressions.normalize(rewritten), (Object)TestSimplifyExpressions.normalize(expectedExpression));
        TestingRowExpressionTranslator translator = new TestingRowExpressionTranslator((Metadata)METADATA);
        RowExpression actualRowExpression = translator.translate(actualExpression, TypeProvider.viewOf(TYPES));
        RowExpression simplifiedRowExpression = SimplifyRowExpressions.rewrite((RowExpression)actualRowExpression, (Metadata)METADATA, (ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession());
        Expression expectedByRowExpression = Optional.ofNullable(rowExpressionExpected).map(expr -> ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expr))).orElse(rewritten);
        RowExpression simplifiedByExpression = translator.translate(expectedByRowExpression, TypeProvider.viewOf(TYPES));
        Assert.assertEquals((Object)simplifiedRowExpression, (Object)simplifiedByExpression);
    }

    private static Set<VariableReferenceExpression> booleanVariablesFor(Expression expression) {
        return (Set)VariablesExtractor.extractAllSymbols((Expression)expression).stream().map(symbol -> new VariableReferenceExpression(symbol.getName(), (Type)BooleanType.BOOLEAN)).collect(ImmutableSet.toImmutableSet());
    }

    private static Expression normalize(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new NormalizeExpressionRewriter(), (Expression)expression);
    }

    private static class NormalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private NormalizeExpressionRewriter() {
        }

        public Expression rewriteLogicalBinaryExpression(LogicalBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List predicates = ExpressionUtils.extractPredicates((LogicalBinaryExpression.Operator)node.getOperator(), (Expression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(Expression::toString)).collect(Collectors.toList());
            return ExpressionUtils.binaryExpression((LogicalBinaryExpression.Operator)node.getOperator(), predicates);
        }
    }
}

