/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformCorrelatedScalarSubquery
extends BaseRuleTest {
    private static final ImmutableList<List<RowExpression>> ONE_ROW = ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)));
    private static final ImmutableList<List<RowExpression>> TWO_ROWS = ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)), (Object)ImmutableList.of((Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT)));
    private Rule rule = new TransformCorrelatedScalarSubquery();

    public TestTransformCorrelatedScalarSubquery() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutLateralNode() {
        this.tester().assertThat(this.rule).on(p -> p.values(p.variable("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedNonScalar() {
        this.tester().assertThat(this.rule).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("corr")), (PlanNode)p.values(p.variable("corr")), (PlanNode)p.values(p.variable("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat(this.rule).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of(), (PlanNode)p.values(p.variable("a")), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("b")), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 1L))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutProjection() {
        this.tester().assertThat(this.rule).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("corr")), (PlanNode)p.values(p.variable("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (List<List<RowExpression>>)TWO_ROWS))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(TestTransformCorrelatedScalarSubquery.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.lateral((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a")))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat(this.rule).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("corr")), (PlanNode)p.values(p.variable("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.project(PlanBuilder.assignment(p.variable("a2"), PlanBuilder.expression("a * 2")), (PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (List<List<RowExpression>>)TWO_ROWS)))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(TestTransformCorrelatedScalarSubquery.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.lateral((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression("a * 2")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a"))))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjectionOnTopEnforceSingleNode() {
        this.tester().assertThat(this.rule).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("corr")), (PlanNode)p.values(p.variable("corr")), (PlanNode)p.project(PlanBuilder.assignment(p.variable("a3"), PlanBuilder.expression("a2 + 1")), (PlanNode)p.enforceSingleRow((PlanNode)p.project(PlanBuilder.assignment(p.variable("a2"), PlanBuilder.expression("a * 2")), (PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (List<List<RowExpression>>)TWO_ROWS))))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(TestTransformCorrelatedScalarSubquery.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.lateral((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a3", (Object)PlanMatchPattern.expression("a2 + 1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression("a * 2")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a")))))))));
    }

    @Test
    public void rewritesScalarSubquery() {
        this.tester().assertThat(this.rule).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("corr")), (PlanNode)p.values(p.variable("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (List<List<RowExpression>>)ONE_ROW))))).matches(PlanMatchPattern.lateral((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a"))));
    }

    private static Expression ensureScalarSubquery() {
        return new SimpleCaseExpression((Expression)new SymbolReference("is_distinct"), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new LongLiteral(Long.toString(StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.ordinal())), (Object)new StringLiteral("Scalar sub-query has returned multiple rows"))), "boolean")));
    }
}

