/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformCorrelatedSingleRowSubqueryToProject
extends BaseRuleTest {
    public TestTransformCorrelatedSingleRowSubqueryToProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.values(p.variable("a"))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("l_nationkey")), (PlanNode)p.tableScan(new TableHandle(new ConnectorId("local"), (ConnectorTableHandle)new TpchTableHandle("nation", 0.01), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("l_nationkey")), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("l_nationkey"), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))), (PlanNode)p.project(PlanBuilder.assignment(p.variable("l_expr2"), PlanBuilder.expression("l_nationkey + 1")), (PlanNode)p.values((List<VariableReferenceExpression>)ImmutableList.of(), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_expr2", (Object)PlanMatchPattern.expression("l_nationkey + 1"), (Object)"l_nationkey", (Object)PlanMatchPattern.expression("l_nationkey")), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"l_nationkey", (Object)"nationkey"))));
    }

    @Test
    public void testDoesNotFireWithEmptyValuesNode() {
        this.tester().assertThat((Rule)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.lateral((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("a")), (PlanNode)p.values(p.variable("a")), (PlanNode)p.values(p.variable("a")))).doesNotFire();
    }
}

