/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.PlanTestSymbol;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAddExchangesPlans
extends BasePlanTest {
    @Test
    public void testRepartitionForUnionWithAnyTableScans() {
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select regionkey from region", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region"))))))));
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values(new String[0]))))))));
    }

    @Test
    public void testRepartitionForUnionAllBeforeHashJoin() {
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select nationkey from nation) n join region r on n.nationkey = r.regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select 1) n join region r on n.nationkey = r.regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values(new String[0])))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    private void assertPlanWithMergePartitionStrategy(String sql, String partitionMergingStrategy, int remoteRepartitionExchangeCount, PlanMatchPattern pattern) {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("aggregation_partitioning_merging_strategy", partitionMergingStrategy).setSystemProperty("task_concurrency", "2").build();
        BiConsumer<Plan, Integer> validateMultipleRemoteRepartitionExchange = (plan, count) -> Assert.assertEquals((int)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE_STREAMING && ((ExchangeNode)node).getType() == ExchangeNode.Type.REPARTITION).count(), (int)count);
        this.assertPlanWithSession(sql, session, false, pattern, plan -> validateMultipleRemoteRepartitionExchange.accept((Plan)plan, remoteRepartitionExchangeCount));
    }

    @Test
    public void testMergePartitionWithGroupingSets() {
        String sql = "SELECT orderkey, count(distinct(custkey)) FROM orders GROUP BY GROUPING SETS((orderkey), ())";
        this.assertPlanWithMergePartitionStrategy(sql, "bottom_up", 2, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(GroupIdNode.class, PlanMatchPattern.tableScan("orders"))))))))))))));
        this.assertPlanWithMergePartitionStrategy(sql, "top_down", 2, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(GroupIdNode.class, PlanMatchPattern.tableScan("orders"))))))))))))));
    }

    @Test
    public void testMergePartitionWithAggregation() {
        String sql = "SELECT count(orderdate), custkey FROM (SELECT orderdate, custkey FROM orders GROUP BY orderdate, custkey) GROUP BY custkey";
        this.assertPlanWithMergePartitionStrategy(sql, "bottom_up", 2, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))))))))))));
        this.assertPlanWithMergePartitionStrategy(sql, "top_down", 1, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders"))))))))));
    }

    @Test
    public void testAggregateIsExactlyPartitioned() {
        this.assertExactDistributedPlan("SELECT\n    AVG(1)\nFROM (\n    SELECT\n        orderkey,\n        orderstatus,\n        COUNT(*)\n    FROM orders\n    WHERE\n        orderdate > CAST('2042-01-01' AS DATE)\n    GROUP BY\n        orderkey,\n        orderstatus\n)\nGROUP BY\n    orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ordertatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey", (Object)"orderdate", (Object)"orderdate"))))))));
    }

    @Test
    public void testWindowIsExactlyPartitioned() {
        this.assertExactDistributedPlan("SELECT\n    AVG(otherwindow) OVER (\n        PARTITION BY\n            orderkey\n    )\nFROM (\n    SELECT\n        orderkey,\n        orderstatus,\n        COUNT(*) OVER (\n            PARTITION BY\n                orderkey,\n                orderstatus\n        ) AS otherwindow\n    FROM orders\n    WHERE\n        orderdate > CAST('2042-01-01' AS DATE)\n)", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"orderdate", (Object)"orderdate"))))))));
    }

    @Test
    public void testRowNumberIsExactlyPartitioned() {
        this.assertExactDistributedPlan("SELECT\n    *\nFROM (\n    SELECT\n        a,\n        ROW_NUMBER() OVER (\n            PARTITION BY\n                a\n        ) rn\n    FROM (\n        VALUES\n            (1)\n    ) t (a)\n) t", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values("a")))));
    }

    @Test
    public void testTopNRowNumberIsExactlyPartitioned() {
        this.assertExactDistributedPlan("SELECT\n    a,\n    ROW_NUMBER() OVER (\n        PARTITION BY\n            a\n        ORDER BY\n            a\n    ) rn\nFROM (\n    SELECT\n        a,\n        b,\n        COUNT(*)\n    FROM (\n        VALUES\n            (1, 2)\n    ) t (a, b)\n    GROUP BY\n        a,\n        b\n)\nLIMIT\n    2", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testJoinExactlyPartitioned() {
        ExpectedValueProvider<FunctionCall> arbitrary = PlanMatchPattern.functionCall("arbitrary", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.assertExactDistributedPlan("SELECT\n    orders.orderkey,\n    orders.orderstatus\nFROM (\n    SELECT\n        orderkey,\n        ARBITRARY(orderstatus) AS orderstatus,\n        COUNT(*)\n    FROM orders\n    GROUP BY\n        orderkey\n) t,\norders\nWHERE\n    orders.orderkey = t.orderkey\n    AND orders.orderstatus = t.orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERKEY_LEFT", "ORDERKEY_RIGHT"), PlanMatchPattern.equiJoinClause("orderstatus", "ORDERSTATUS_RIGHT")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("ORDERKEY_LEFT"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("orderstatus"), arbitrary), (List<String>)ImmutableList.of((Object)"ORDERKEY_LEFT"), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY_LEFT", (Object)"orderkey", (Object)"ORDERSTATUS_LEFT", (Object)"orderstatus"))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY_RIGHT", (Object)"orderkey", (Object)"ORDERSTATUS_RIGHT", (Object)"orderstatus"))))))));
    }

    @Test
    public void testSemiJoinExactlyPartitioned() {
        this.assertExactDistributedPlan("SELECT\n    orderkey\nFROM orders\nWHERE\n    orderkey IN (\n        SELECT\n            orderkey\n        FROM orders\n        WHERE\n            orderkey IS NULL\n            AND orderstatus IS NULL\n    )", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("ORDERKEY_OK", "VALUE_ORDERKEY", "S", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY_OK", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values("VALUE_ORDERKEY")))))));
    }

    @Test
    public void testMarkDistinctIsExactlyPartitioned() {
        this.assertExactDistributedPlan("    SELECT\n        orderkey,\n        orderstatus,\n        COUNT(DISTINCT orderdate),\n        COUNT(DISTINCT clerk)\n    FROM orders\n    WHERE\n        orderdate > CAST('2042-01-01' AS DATE)\n    GROUP BY\n        orderkey,\n        orderstatus\n", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey", (Object)"clerk", (Object)"clerk", (Object)"orderdate", (Object)"orderdate"))))))))));
    }

    @Test
    public void testMarkDistinctStreamingExchange() {
        this.assertMaterializedWithStreamingMarkDistinctDistributedPlan("    SELECT\n        orderkey,\n        orderstatus,\n        COUNT(DISTINCT orderdate),\n        COUNT(DISTINCT clerk)\n    FROM orders\n    WHERE\n        orderdate > CAST('2042-01-01' AS DATE)\n    GROUP BY\n        orderkey,\n        orderstatus\n", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_MATERIALIZED, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey", (Object)"clerk", (Object)"clerk", (Object)"orderdate", (Object)"orderdate"))))))))));
    }

    void assertMaterializedWithStreamingMarkDistinctDistributedPlan(String sql, PlanMatchPattern pattern) {
        this.assertDistributedPlan(sql, TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("partitioning_precision_strategy", FeaturesConfig.PartitioningPrecisionStrategy.PREFER_EXACT_PARTITIONING.toString()).setSystemProperty("exchange_materialization_strategy", QueryManagerConfig.ExchangeMaterializationStrategy.ALL.toString()).setSystemProperty("use_stream_exchange_for_mark_distinct", "true").build(), pattern);
    }

    void assertExactDistributedPlan(String sql, PlanMatchPattern pattern) {
        this.assertDistributedPlan(sql, TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("partitioning_precision_strategy", FeaturesConfig.PartitioningPrecisionStrategy.PREFER_EXACT_PARTITIONING.toString()).build(), pattern);
    }
}

