/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.presto.sql.query.QueryAssertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestNumericalStability {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testVariance() {
        this.assertions.assertQuery("SELECT CAST(VAR_SAMP(x + exp(30))/VAR_SAMP(x) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)", "VALUES 1.00");
    }

    @Test
    public void testCovariance() {
        this.assertions.assertQuery("SELECT CAST(COVAR_SAMP(x + exp(30), x + exp(30))/VAR_SAMP(x) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)", "VALUES 1.00");
    }

    @Test
    public void testCorrelation() {
        this.assertions.assertQuery("SELECT CAST(CORR(x + exp(30), x + exp(30)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)", "VALUES 1.00");
    }

    @Test
    public void testRegressionSlope() {
        this.assertions.assertQuery("SELECT CAST(REGR_SLOPE((x + exp(30)) * 5 + 8, x + exp(30)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)", "VALUES 5.00");
    }

    @Test
    public void testRegressionIntercept() {
        this.assertions.assertQuery("SELECT CAST(REGR_INTERCEPT((x + exp(20)) * 5 + 8, x + exp(20)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)", "VALUES 8.00");
    }
}

