/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowExpressionOptimizer {
    private FunctionAndTypeManager functionAndTypeManager;
    private RowExpressionOptimizer optimizer;

    @BeforeClass
    public void setUp() {
        this.functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        this.optimizer = new RowExpressionOptimizer((Metadata)MetadataManager.createTestMetadataManager());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.optimizer = null;
    }

    @Test(timeOut=10000L)
    public void testPossibleExponentialOptimizationTime() {
        ConstantExpression expression = Expressions.constant((Object)1L, (Type)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            FunctionHandle functionHandle = this.functionAndTypeManager.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
            expression = new CallExpression(OperatorType.ADD.name(), functionHandle, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)expression, (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)));
        }
        this.optimize((RowExpression)expression);
    }

    @Test
    public void testIfConstantOptimization() {
        Assert.assertEquals((Object)this.optimize(TestRowExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimize(TestRowExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimize(TestRowExpressionOptimizer.ifExpression((RowExpression)Expressions.constant(null, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        FunctionHandle bigintEquals = this.functionAndTypeManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        CallExpression condition = new CallExpression(OperatorType.EQUAL.name(), bigintEquals, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.optimize(TestRowExpressionOptimizer.ifExpression((RowExpression)condition, 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
    }

    @Test
    public void testCastWithJsonParseOptimization() {
        FunctionHandle jsonParseFunctionHandle = this.functionAndTypeManager.lookupFunction("json_parse", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        FunctionHandle jsonCastFunctionHandle = this.functionAndTypeManager.lookupCast(CastType.CAST, JsonType.JSON.getTypeSignature(), TypeSignature.parseTypeSignature((String)"array(integer)"));
        CallExpression jsonCastExpression = new CallExpression(CastType.CAST.name(), jsonCastFunctionHandle, (Type)new ArrayType((Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)Expressions.call((String)"json_parse", (FunctionHandle)jsonParseFunctionHandle, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.constant((Object)Slices.utf8Slice((String)"[1, 2]"), (Type)VarcharType.VARCHAR)})));
        RowExpression resultExpression = this.optimize((RowExpression)jsonCastExpression);
        Assertions.assertInstanceOf((Object)resultExpression, ConstantExpression.class);
        Object resultValue = ((ConstantExpression)resultExpression).getValue();
        Assertions.assertInstanceOf((Object)resultValue, IntArrayBlock.class);
        Assert.assertEquals(BlockAssertions.toValues((Type)IntegerType.INTEGER, (Block)((IntArrayBlock)resultValue)), (Collection)ImmutableList.of((Object)1, (Object)2));
        jsonCastFunctionHandle = this.functionAndTypeManager.lookupCast(CastType.CAST, JsonType.JSON.getTypeSignature(), TypeSignature.parseTypeSignature((String)"array(varchar)"));
        jsonCastExpression = Expressions.call((String)CastType.CAST.name(), (FunctionHandle)jsonCastFunctionHandle, (Type)new ArrayType((Type)VarcharType.VARCHAR), (List)ImmutableList.of((Object)Expressions.call((String)"json_parse", (FunctionHandle)jsonParseFunctionHandle, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        resultExpression = this.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((String)CastType.JSON_TO_ARRAY_CAST.name(), (FunctionHandle)this.functionAndTypeManager.lookupCast(CastType.JSON_TO_ARRAY_CAST, VarcharType.VARCHAR.getTypeSignature(), TypeSignature.parseTypeSignature((String)"array(varchar)")), (Type)new ArrayType((Type)VarcharType.VARCHAR), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
        jsonCastFunctionHandle = this.functionAndTypeManager.lookupCast(CastType.CAST, JsonType.JSON.getTypeSignature(), TypeSignature.parseTypeSignature((String)"map(integer,varchar)"));
        jsonCastExpression = Expressions.call((String)CastType.CAST.name(), (FunctionHandle)jsonCastFunctionHandle, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR), (List)ImmutableList.of((Object)Expressions.call((String)"json_parse", (FunctionHandle)jsonParseFunctionHandle, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        resultExpression = this.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((String)CastType.JSON_TO_MAP_CAST.name(), (FunctionHandle)this.functionAndTypeManager.lookupCast(CastType.JSON_TO_MAP_CAST, VarcharType.VARCHAR.getTypeSignature(), TypeSignature.parseTypeSignature((String)"map(integer, varchar)")), (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
        jsonCastFunctionHandle = this.functionAndTypeManager.lookupCast(CastType.CAST, JsonType.JSON.getTypeSignature(), TypeSignature.parseTypeSignature((String)"row(varchar,bigint)"));
        jsonCastExpression = Expressions.call((String)CastType.CAST.name(), (FunctionHandle)jsonCastFunctionHandle, (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)), (List)ImmutableList.of((Object)Expressions.call((String)"json_parse", (FunctionHandle)jsonParseFunctionHandle, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        resultExpression = this.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((String)CastType.JSON_TO_ROW_CAST.name(), (FunctionHandle)this.functionAndTypeManager.lookupCast(CastType.JSON_TO_ROW_CAST, VarcharType.VARCHAR.getTypeSignature(), TypeSignature.parseTypeSignature((String)"row(varchar,bigint)")), (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
    }

    private static RowExpression ifExpression(RowExpression condition, long trueValue, long falseValue) {
        return new SpecialFormExpression(SpecialFormExpression.Form.IF, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)condition, (Object)Expressions.constant((Object)trueValue, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)falseValue, (Type)BigintType.BIGINT)));
    }

    private RowExpression optimize(RowExpression expression) {
        return this.optimizer.optimize(expression, ExpressionOptimizer.Level.OPTIMIZED, TestingConnectorSession.SESSION);
    }
}

