/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.type.AbstractTestType;
import com.facebook.presto.type.IpPrefixType;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIpPrefixType
extends AbstractTestType {
    public TestIpPrefixType() {
        super((Type)IpPrefixType.IPPREFIX, String.class, TestIpPrefixType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = IpPrefixType.IPPREFIX.createBlockBuilder(null, 1);
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8320/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8321/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8322/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8323/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8324/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8325/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8326/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8327/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8328/48"));
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, TestIpPrefixType.getSliceForPrefix("2001:db8::ff00:42:8329/48"));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        byte[] prefix = ((Slice)value).getBytes();
        int n = prefix.length - 2;
        byte by = (byte)(prefix[n] + 1);
        prefix[n] = by;
        Preconditions.checkState((by != 0 ? 1 : 0) != 0, (Object)"Last byte of address is 0xff");
        return Slices.wrappedBuffer((byte[])prefix);
    }

    @Override
    protected Object getNonNullValue() {
        byte[] bytes = new byte[IpPrefixType.IPPREFIX.getFixedSize()];
        byte[] ipAddress = InetAddresses.forString((String)"::").getAddress();
        System.arraycopy(ipAddress, 0, bytes, 0, 16);
        bytes[IpPrefixType.IPPREFIX.getFixedSize() - 1] = 32;
        return Slices.wrappedBuffer((byte[])bytes);
    }

    @Test
    public void testDisplayName() {
        Assert.assertEquals((String)IpPrefixType.IPPREFIX.getDisplayName(), (String)"ipprefix");
    }

    private static Slice getSliceForPrefix(String prefix) {
        String[] parts = prefix.split("/");
        byte[] bytes = new byte[IpPrefixType.IPPREFIX.getFixedSize()];
        byte[] ipAddress = InetAddresses.forString((String)parts[0]).getAddress();
        System.arraycopy(ipAddress, 0, bytes, 0, 16);
        bytes[IpPrefixType.IPPREFIX.getFixedSize() - 1] = (byte)Integer.parseInt(parts[1]);
        return Slices.wrappedBuffer((byte[])bytes);
    }
}

