/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.StringTableUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStringTableUtils {
    @Test
    public void testGetShortestTableStringFormatSimpleSuccess() {
        List<List> table = Arrays.asList(Arrays.asList("Header1", "Header2", "Headr3"), Arrays.asList("Value1", "Value2", "Value3"), Arrays.asList("LongValue1", "SVal2", "SVal3"));
        com.facebook.presto.testing.assertions.Assert.assertEquals((String)StringTableUtils.getShortestTableStringFormat(table), (String)"| %-10s | %-7s | %-6s |");
    }

    @Test
    public void testGetShortestTableStringFormatBadInput() {
        List<List> table = Arrays.asList(Arrays.asList("Header1", "Header2", "Headr3"), Arrays.asList("Value1", "Value2"), Arrays.asList("LongValue1", "SVal2", "SVal3"));
        Assert.assertThrows(IllegalArgumentException.class, () -> StringTableUtils.getShortestTableStringFormat((List)table));
    }

    @Test
    public void testGetTableStringsSimpleSuccess() {
        List<List> table = Arrays.asList(Arrays.asList("Header1", "Header2", "Headr3"), Arrays.asList("Value1", "Value2", "Value3"), Arrays.asList("LongValue1", "SVal2", "SVal3"));
        com.facebook.presto.testing.assertions.Assert.assertEquals((Collection)StringTableUtils.getTableStrings(table), Arrays.asList("| Header1    | Header2 | Headr3 |", "| Value1     | Value2  | Value3 |", "| LongValue1 | SVal2   | SVal3  |"));
    }
}

