/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.internal.JdbiStreams;
import org.jdbi.v3.core.statement.StatementContext;

public class Binding {
    private final Map<Integer, Argument> positionals = new HashMap<Integer, Argument>();
    private final Map<String, Argument> named = new HashMap<String, Argument>();
    private final List<NamedArgumentFinder> namedArgumentFinder = new ArrayList<NamedArgumentFinder>();

    public void addPositional(int position, Argument argument) {
        this.positionals.put(position, argument);
    }

    public void addNamed(String name, Argument argument) {
        this.named.put(name, argument);
    }

    public void addNamedArgumentFinder(NamedArgumentFinder args) {
        this.namedArgumentFinder.add(args);
    }

    public Optional<Argument> findForName(String name, StatementContext ctx) {
        if (this.named.containsKey(name)) {
            return Optional.of(this.named.get(name));
        }
        return this.namedArgumentFinder.stream().flatMap(arguments -> JdbiStreams.toStream(arguments.find(name, ctx))).findFirst();
    }

    public Optional<Argument> findForPosition(int position) {
        return Optional.ofNullable(this.positionals.get(position));
    }

    public String toString() {
        String positionals = this.positionals.entrySet().stream().map(x -> ((Integer)x.getKey()).toString() + ':' + x.getValue()).collect(Collectors.joining(","));
        String named = this.named.entrySet().stream().map(x -> (String)x.getKey() + ':' + x.getValue()).collect(Collectors.joining(","));
        String found = this.namedArgumentFinder.stream().map(Object::toString).collect(Collectors.joining(","));
        return "{positional:{" + positionals + "}, named:{" + named + "}, finder:[" + found + "]}";
    }

    public void clear() {
        this.positionals.clear();
        this.named.clear();
        this.namedArgumentFinder.clear();
    }

    public boolean isEmpty() {
        return this.positionals.isEmpty() && this.named.isEmpty() && this.namedArgumentFinder.isEmpty();
    }
}

