/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultProducers;
import org.jdbi.v3.core.result.ResultSetScanner;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.StatementCustomizers;

public class Query
extends SqlStatement<Query>
implements ResultBearing {
    public Query(Handle handle, String sql) {
        super(handle, sql);
    }

    public <R> R execute(ResultProducer<R> producer) {
        try {
            return producer.produce(this::internalExecute, this.getContext());
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw new UnableToProduceResultException(e, this.getContext());
        }
    }

    @Override
    public <R> R scanResultSet(ResultSetScanner<R> mapper) {
        return this.execute(ResultProducers.returningResults()).scanResultSet(mapper);
    }

    public Query setFetchSize(int fetchSize) {
        return (Query)this.addCustomizer(StatementCustomizers.fetchSize(fetchSize));
    }

    public Query setMaxRows(int maxRows) {
        return (Query)this.addCustomizer(StatementCustomizers.maxRows(maxRows));
    }

    public Query setMaxFieldSize(int maxFields) {
        return (Query)this.addCustomizer(StatementCustomizers.maxFieldSize(maxFields));
    }

    public Query concurrentUpdatable() {
        this.getContext().setConcurrentUpdatable(true);
        return this;
    }
}

