/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Id<T> {
    private final String id;

    @JsonCreator
    public static <T> Id<T> valueOf(String id) {
        return new Id<T>(id);
    }

    public static <T> Id<T> random() {
        return new Id<T>(UUID.randomUUID().toString());
    }

    private Id(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"id is empty");
        this.id = id;
    }

    @JsonValue
    public String get() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Id)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    public byte[] getBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }
}

