/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.discovery.server.ForStaticStore;
import com.facebook.airlift.discovery.server.Id;
import com.facebook.airlift.discovery.server.Service;
import com.facebook.airlift.discovery.server.StaticStore;
import com.facebook.airlift.discovery.store.DistributedStore;
import com.facebook.airlift.discovery.store.Entry;
import com.facebook.airlift.json.JsonCodec;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;

public class ReplicatedStaticStore
implements StaticStore {
    private final DistributedStore store;
    private final JsonCodec<Service> codec;

    @Inject
    public ReplicatedStaticStore(@ForStaticStore DistributedStore store, JsonCodec<Service> codec) {
        this.store = (DistributedStore)Preconditions.checkNotNull((Object)store, (Object)"store is null");
        this.codec = (JsonCodec)Preconditions.checkNotNull(codec, (Object)"codec is null");
    }

    @Override
    public void put(Service service) {
        byte[] key = service.getId().getBytes();
        byte[] value = this.codec.toJsonBytes((Object)service);
        this.store.put(key, value);
    }

    @Override
    public void delete(Id<Service> id) {
        this.store.delete(id.getBytes());
    }

    @Override
    public Set<Service> getAll() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Entry entry : this.store.getAll()) {
            builder.add(this.codec.fromJson(entry.getValue()));
        }
        return builder.build();
    }

    @Override
    public Set<Service> get(String type) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.getAll(), Service.matchesType(type)));
    }

    @Override
    public Set<Service> get(String type, String pool) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.getAll(), (Predicate)Predicates.and(Service.matchesType(type), Service.matchesPool(pool))));
    }
}

