/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server.testing;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.discovery.client.DiscoveryModule;
import com.facebook.airlift.discovery.server.EmbeddedDiscoveryModule;
import com.facebook.airlift.http.server.testing.TestingHttpServer;
import com.facebook.airlift.http.server.testing.TestingHttpServerModule;
import com.facebook.airlift.jaxrs.JaxrsModule;
import com.facebook.airlift.jmx.testing.TestingJmxModule;
import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.node.testing.TestingNodeModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import org.weakref.jmx.guice.MBeanModule;

public class TestingDiscoveryServer
implements AutoCloseable {
    private final LifeCycleManager lifeCycleManager;
    private final TestingHttpServer server;

    public TestingDiscoveryServer(String environment) throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new TestingNodeModule(environment), new TestingHttpServerModule(), new JsonModule(), new JaxrsModule(true), new TestingJmxModule(), new DiscoveryModule(), new EmbeddedDiscoveryModule()});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperty("discovery.store-cache-ttl", "0ms").quiet().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    @Override
    public void close() throws Exception {
        if (this.lifeCycleManager != null) {
            this.lifeCycleManager.stop();
        }
    }
}

