/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import java.util.Optional;

public class EnforceSingleRowStatsRule
extends SimpleStatsRule<EnforceSingleRowNode> {
    private static final Pattern<EnforceSingleRowNode> PATTERN = Patterns.enforceSingleRow();

    public EnforceSingleRowStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<EnforceSingleRowNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(EnforceSingleRowNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return Optional.of(PlanNodeStatsEstimate.buildFrom(sourceStats.getStats(node.getSource())).setOutputRowCount(1.0).build());
    }
}

