/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import java.util.Objects;
import java.util.Optional;

public abstract class SimpleStatsRule<T extends PlanNode>
implements ComposableStatsCalculator.Rule<T> {
    private final StatsNormalizer normalizer;

    protected SimpleStatsRule(StatsNormalizer normalizer) {
        this.normalizer = Objects.requireNonNull(normalizer, "normalizer is null");
    }

    @Override
    public final Optional<PlanNodeStatsEstimate> calculate(T node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return this.doCalculate(node, sourceStats, lookup, session, types).map(estimate -> this.normalizer.normalize((PlanNodeStatsEstimate)estimate, node.getOutputVariables()));
    }

    protected abstract Optional<PlanNodeStatsEstimate> doCalculate(T var1, StatsProvider var2, Lookup var3, Session var4, TypeProvider var5);
}

