/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class UnionStatsRule
extends SimpleStatsRule<UnionNode> {
    private static final Pattern<UnionNode> PATTERN = Patterns.union();

    public UnionStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<UnionNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected final Optional<PlanNodeStatsEstimate> doCalculate(UnionNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        Preconditions.checkArgument((!node.getSources().isEmpty() ? 1 : 0) != 0, (Object)"Empty Union is not supported");
        Optional<PlanNodeStatsEstimate> estimate = Optional.empty();
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = (PlanNode)node.getSources().get(i);
            PlanNodeStatsEstimate sourceStats = statsProvider.getStats(source);
            PlanNodeStatsEstimate sourceStatsWithMappedSymbols = this.mapToOutputSymbols(sourceStats, node, i);
            estimate = estimate.isPresent() ? Optional.of(PlanNodeStatsEstimateMath.addStatsAndCollapseDistinctValues(estimate.get(), sourceStatsWithMappedSymbols)) : Optional.of(sourceStatsWithMappedSymbols);
        }
        return estimate;
    }

    private PlanNodeStatsEstimate mapToOutputSymbols(PlanNodeStatsEstimate estimate, UnionNode node, int index) {
        PlanNodeStatsEstimate.Builder mapped = PlanNodeStatsEstimate.builder().setOutputRowCount(estimate.getOutputRowCount());
        node.getOutputVariables().forEach(variable -> mapped.addVariableStatistics((VariableReferenceExpression)variable, estimate.getVariableStatistics((VariableReferenceExpression)((List)node.getVariableMapping().get(variable)).get(index))));
        return mapped.build();
    }
}

