/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.execution.QueryManagerConfig;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DispatchExecutor {
    private final Closer closer = Closer.create();
    private final ListeningExecutorService executor;
    private final BoundedExecutor boundedExecutor;
    private final ListeningScheduledExecutorService scheduledExecutor;
    private final DispatchExecutorMBeans mbeans;

    @Inject
    public DispatchExecutor(QueryManagerConfig config) {
        ExecutorService coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"dispatcher-query-%s"));
        this.closer.register(coreExecutor::shutdownNow);
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)coreExecutor);
        this.boundedExecutor = new BoundedExecutor((Executor)coreExecutor, config.getQuerySubmissionMaxThreads());
        ScheduledExecutorService coreScheduledExecutor = Executors.newScheduledThreadPool(config.getQueryManagerExecutorPoolSize(), Threads.daemonThreadsNamed((String)"dispatch-executor-%s"));
        this.closer.register(coreScheduledExecutor::shutdownNow);
        this.scheduledExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)coreScheduledExecutor);
        this.mbeans = new DispatchExecutorMBeans(coreExecutor, coreScheduledExecutor);
    }

    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    public BoundedExecutor getBoundedExecutor() {
        return this.boundedExecutor;
    }

    public ListeningScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Managed
    @Flatten
    public DispatchExecutorMBeans getMbeans() {
        return this.mbeans;
    }

    @PreDestroy
    public void shutdown() throws Exception {
        this.closer.close();
    }

    public class DispatchExecutorMBeans {
        private final ThreadPoolExecutorMBean executor;
        private final ThreadPoolExecutorMBean scheduledExecutor;

        public DispatchExecutorMBeans(ExecutorService coreExecutor, ScheduledExecutorService coreScheduledExecutor) {
            Objects.requireNonNull(coreExecutor, "coreExecutor is null");
            Objects.requireNonNull(coreScheduledExecutor, "coreScheduledExecutor is null");
            this.executor = new ThreadPoolExecutorMBean((ThreadPoolExecutor)coreExecutor);
            this.scheduledExecutor = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)coreScheduledExecutor));
        }

        @Managed
        @Nested
        public ThreadPoolExecutorMBean getExecutor() {
            return this.executor;
        }

        @Managed
        @Nested
        public ThreadPoolExecutorMBean getScheduledExecutor() {
            return this.scheduledExecutor;
        }
    }
}

