/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.CanonicalPlanFragment;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FragmentResultCacheContext {
    private static final Set<Class<? extends PlanNode>> ALLOWED_CHILDREN_NODES = ImmutableSet.of(TableScanNode.class, FilterNode.class, ProjectNode.class, GroupIdNode.class);
    private final FragmentResultCacheManager fragmentResultCacheManager;
    private final CanonicalPlanFragment canonicalPlanFragment;

    public static Optional<FragmentResultCacheContext> createFragmentResultCacheContext(FragmentResultCacheManager fragmentResultCacheManager, PlanNode root, PartitioningScheme partitioningScheme, Session session) {
        if (!SystemSessionProperties.isFragmentResultCachingEnabled(session) || !FragmentResultCacheContext.isEligibleForFragmentResultCaching(root)) {
            return Optional.empty();
        }
        Optional<CanonicalPlanFragment> canonicalPlanFragment = CanonicalPlanGenerator.generateCanonicalPlan(root, partitioningScheme);
        return canonicalPlanFragment.map(fragment -> new FragmentResultCacheContext(fragmentResultCacheManager, (CanonicalPlanFragment)fragment));
    }

    private static boolean isEligibleForFragmentResultCaching(PlanNode root) {
        if (!(root instanceof AggregationNode) || ((AggregationNode)root).getStep() != AggregationNode.Step.PARTIAL) {
            return false;
        }
        return root.getSources().stream().allMatch(FragmentResultCacheContext::containsOnlyAllowedNodesInChildren);
    }

    private static boolean containsOnlyAllowedNodesInChildren(PlanNode node) {
        if (!ALLOWED_CHILDREN_NODES.contains(node.getClass())) {
            return false;
        }
        return node.getSources().stream().allMatch(FragmentResultCacheContext::containsOnlyAllowedNodesInChildren);
    }

    private FragmentResultCacheContext(FragmentResultCacheManager fragmentResultCacheManager, CanonicalPlanFragment canonicalPlanFragment) {
        this.fragmentResultCacheManager = Objects.requireNonNull(fragmentResultCacheManager, "fragmentResultCacheManager is null");
        this.canonicalPlanFragment = Objects.requireNonNull(canonicalPlanFragment, "canonicalPlanFragment is null");
    }

    public FragmentResultCacheManager getFragmentResultCacheManager() {
        return this.fragmentResultCacheManager;
    }

    public CanonicalPlanFragment getCanonicalPlanFragment() {
        return this.canonicalPlanFragment;
    }
}

