/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.sql.planner.PlanFragment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageInfo {
    private final StageId stageId;
    private final URI self;
    private final Optional<PlanFragment> plan;
    private final StageExecutionInfo latestAttemptExecutionInfo;
    private final List<StageExecutionInfo> previousAttemptsExecutionInfos;
    private final List<StageInfo> subStages;
    private final boolean isRuntimeOptimized;

    @JsonCreator
    public StageInfo(@JsonProperty(value="stageId") StageId stageId, @JsonProperty(value="self") URI self, @JsonProperty(value="plan") Optional<PlanFragment> plan, @JsonProperty(value="latestAttemptExecutionInfo") StageExecutionInfo latestAttemptExecutionInfo, @JsonProperty(value="previousAttemptsExecutionInfos") List<StageExecutionInfo> previousAttemptsExecutionInfos, @JsonProperty(value="subStages") List<StageInfo> subStages, @JsonProperty(value="isRuntimeOptimized") boolean isRuntimeOptimized) {
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.self = Objects.requireNonNull(self, "self is null");
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.latestAttemptExecutionInfo = Objects.requireNonNull(latestAttemptExecutionInfo, "latestAttemptExecutionInfo is null");
        this.previousAttemptsExecutionInfos = ImmutableList.copyOf((Collection)Objects.requireNonNull(previousAttemptsExecutionInfos, "previousAttemptsExecutionInfos is null"));
        this.subStages = ImmutableList.copyOf((Collection)Objects.requireNonNull(subStages, "subStages is null"));
        this.isRuntimeOptimized = isRuntimeOptimized;
    }

    @JsonProperty
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public Optional<PlanFragment> getPlan() {
        return this.plan;
    }

    @JsonProperty
    public StageExecutionInfo getLatestAttemptExecutionInfo() {
        return this.latestAttemptExecutionInfo;
    }

    @JsonProperty
    public List<StageExecutionInfo> getPreviousAttemptsExecutionInfos() {
        return this.previousAttemptsExecutionInfos;
    }

    @JsonProperty
    public List<StageInfo> getSubStages() {
        return this.subStages;
    }

    @JsonProperty
    public boolean isRuntimeOptimized() {
        return this.isRuntimeOptimized;
    }

    public boolean isFinalStageInfo() {
        return this.latestAttemptExecutionInfo.isFinal();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("state", (Object)this.latestAttemptExecutionInfo.getState()).toString();
    }

    public List<StageInfo> getAllStages() {
        return ImmutableList.copyOf((Iterable)Traverser.forTree(StageInfo::getSubStages).depthFirstPreOrder((Object)this));
    }

    public static List<StageInfo> getAllStages(Optional<StageInfo> stageInfo) {
        return stageInfo.map(StageInfo::getAllStages).orElse((List)ImmutableList.of());
    }
}

