/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"node-scheduler.location-aware-scheduling-enabled", "node-scheduler.multiple-tasks-per-node-enabled"})
public class NodeSchedulerConfig {
    private int minCandidates = 10;
    private boolean includeCoordinator = true;
    private int maxSplitsPerNode = 100;
    private int maxPendingSplitsPerTask = 10;
    private String networkTopology = "legacy";

    @NotNull
    public String getNetworkTopology() {
        return this.networkTopology;
    }

    @Config(value="node-scheduler.network-topology")
    public NodeSchedulerConfig setNetworkTopology(String networkTopology) {
        this.networkTopology = networkTopology;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinCandidates() {
        return this.minCandidates;
    }

    @Config(value="node-scheduler.min-candidates")
    public NodeSchedulerConfig setMinCandidates(int candidates) {
        this.minCandidates = candidates;
        return this;
    }

    public boolean isIncludeCoordinator() {
        return this.includeCoordinator;
    }

    @Config(value="node-scheduler.include-coordinator")
    public NodeSchedulerConfig setIncludeCoordinator(boolean includeCoordinator) {
        this.includeCoordinator = includeCoordinator;
        return this;
    }

    @Config(value="node-scheduler.max-pending-splits-per-task")
    @LegacyConfig(value={"node-scheduler.max-pending-splits-per-node-per-task", "node-scheduler.max-pending-splits-per-node-per-stage"})
    public NodeSchedulerConfig setMaxPendingSplitsPerTask(int maxPendingSplitsPerTask) {
        this.maxPendingSplitsPerTask = maxPendingSplitsPerTask;
        return this;
    }

    public int getMaxPendingSplitsPerTask() {
        return this.maxPendingSplitsPerTask;
    }

    public int getMaxSplitsPerNode() {
        return this.maxSplitsPerNode;
    }

    @Config(value="node-scheduler.max-splits-per-node")
    public NodeSchedulerConfig setMaxSplitsPerNode(int maxSplitsPerNode) {
        this.maxSplitsPerNode = maxSplitsPerNode;
        return this;
    }

    public static class NetworkTopologyType {
        public static final String LEGACY = "legacy";
        public static final String FLAT = "flat";
        public static final String BENCHMARK = "benchmark";
    }
}

