/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.group;

import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.InternalNodeInfo;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public class DynamicBucketNodeMap
extends BucketNodeMap {
    private final int bucketCount;
    private final Int2ObjectMap<InternalNodeInfo> bucketToNodeInfo = new Int2ObjectOpenHashMap();
    private final boolean hasInitialMap;

    public DynamicBucketNodeMap(ToIntFunction<Split> splitToBucket, int bucketCount) {
        super(splitToBucket);
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be positive");
        this.bucketCount = bucketCount;
        this.hasInitialMap = false;
    }

    public DynamicBucketNodeMap(ToIntFunction<Split> splitToBucket, int bucketCount, List<InternalNode> bucketToPreferredNode) {
        super(splitToBucket);
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be positive");
        Preconditions.checkArgument((bucketToPreferredNode.size() == bucketCount ? 1 : 0) != 0, (Object)"bucketToPreferredNode size must be equal to bucketCount");
        for (int bucketNumber = 0; bucketNumber < bucketCount; ++bucketNumber) {
            this.bucketToNodeInfo.put(bucketNumber, (Object)new InternalNodeInfo(bucketToPreferredNode.get(bucketNumber), true));
        }
        this.bucketCount = bucketCount;
        this.hasInitialMap = true;
    }

    @Override
    public Optional<InternalNode> getAssignedNode(int bucketedId) {
        if (!this.bucketToNodeInfo.containsKey(bucketedId)) {
            return Optional.empty();
        }
        return Optional.of(((InternalNodeInfo)this.bucketToNodeInfo.get(bucketedId)).getInternalNode());
    }

    @Override
    public boolean isBucketCacheable(int bucketedId) {
        if (!this.bucketToNodeInfo.containsKey(bucketedId)) {
            return false;
        }
        return ((InternalNodeInfo)this.bucketToNodeInfo.get(bucketedId)).isCacheable();
    }

    @Override
    public int getBucketCount() {
        return this.bucketCount;
    }

    @Override
    public void assignOrUpdateBucketToNode(int bucketedId, InternalNode node, boolean cacheable) {
        Preconditions.checkArgument((bucketedId >= 0 && bucketedId < this.bucketCount ? 1 : 0) != 0);
        Objects.requireNonNull(node, "node is null");
        this.bucketToNodeInfo.put(bucketedId, (Object)new InternalNodeInfo(node, cacheable));
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean hasInitialMap() {
        return this.hasInitialMap;
    }

    @Override
    public Optional<List<InternalNode>> getBucketToNode() {
        if (this.bucketToNodeInfo.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.bucketToNodeInfo.values().stream().map(InternalNodeInfo::getInternalNode).collect(Collectors.toList()));
    }
}

