/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import java.util.Objects;

public class MemoryInfo {
    private final DataSize totalNodeMemory;
    private final Map<MemoryPoolId, MemoryPoolInfo> pools;

    @JsonCreator
    public MemoryInfo(@JsonProperty(value="totalNodeMemory") DataSize totalNodeMemory, @JsonProperty(value="pools") Map<MemoryPoolId, MemoryPoolInfo> pools) {
        this.totalNodeMemory = Objects.requireNonNull(totalNodeMemory, "totalNodeMemory is null");
        this.pools = ImmutableMap.copyOf(Objects.requireNonNull(pools, "pools is null"));
    }

    @JsonProperty
    public DataSize getTotalNodeMemory() {
        return this.totalNodeMemory;
    }

    @JsonProperty
    public Map<MemoryPoolId, MemoryPoolInfo> getPools() {
        return this.pools;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("totalNodeMemory", (Object)this.totalNodeMemory).add("pools", this.pools).toString();
    }
}

