/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.LowMemoryKiller;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TotalReservationOnBlockedNodesLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<QueryId> chooseQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        HashMap memoryReservationOnBlockedNodes = new HashMap();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo generalPool = node.getPools().get(LocalMemoryManager.GENERAL_POOL);
            if (generalPool == null || generalPool.getFreeBytes() + generalPool.getReservedRevocableBytes() > 0L) continue;
            Map queryMemoryReservations = generalPool.getQueryMemoryReservations();
            queryMemoryReservations.forEach((queryId, memoryReservation) -> memoryReservationOnBlockedNodes.compute(queryId, (id, oldValue) -> oldValue == null ? memoryReservation : oldValue + memoryReservation));
        }
        return memoryReservationOnBlockedNodes.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey);
    }
}

