/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;

public enum CastType {
    CAST(OperatorType.CAST.getFunctionName(), true),
    SATURATED_FLOOR_CAST(OperatorType.SATURATED_FLOOR_CAST.getFunctionName(), true),
    TRY_CAST(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"TRY_CAST"), false),
    JSON_TO_ARRAY_CAST(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_array_cast"), false),
    JSON_TO_MAP_CAST(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_map_cast"), false),
    JSON_TO_ROW_CAST(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_row_cast"), false);

    private final QualifiedFunctionName castName;
    private final boolean isOperatorType;

    private CastType(QualifiedFunctionName castName, boolean isOperatorType) {
        this.castName = castName;
        this.isOperatorType = isOperatorType;
    }

    public QualifiedFunctionName getCastName() {
        return this.castName;
    }

    public boolean isOperatorType() {
        return this.isOperatorType;
    }

    public static OperatorType toOperatorType(CastType castType) {
        switch (castType) {
            case CAST: {
                return OperatorType.CAST;
            }
            case SATURATED_FLOOR_CAST: {
                return OperatorType.SATURATED_FLOOR_CAST;
            }
        }
        throw new IllegalArgumentException(String.format("No OperatorType for CastType %s", new Object[]{castType}));
    }
}

