/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionHandle;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionInvokerProvider;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class FunctionAndTypeManager
implements FunctionMetadataManager,
TypeManager {
    private final TransactionManager transactionManager;
    private final TypeRegistry builtInTypeRegistry;
    private final BuiltInFunctionNamespaceManager builtInFunctionNamespaceManager;
    private final FunctionInvokerProvider functionInvokerProvider;
    private final Map<String, FunctionNamespaceManagerFactory> functionNamespaceManagerFactories = new ConcurrentHashMap<String, FunctionNamespaceManagerFactory>();
    private final HandleResolver handleResolver;
    private final Map<String, FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManagers = new ConcurrentHashMap<String, FunctionNamespaceManager<? extends SqlFunction>>();
    private final LoadingCache<FunctionResolutionCacheKey, FunctionHandle> functionCache;
    private final CacheStatsMBean cacheStatsMBean;

    @Inject
    public FunctionAndTypeManager(TransactionManager transactionManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig, HandleResolver handleResolver, Set<Type> types) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.builtInFunctionNamespaceManager = new BuiltInFunctionNamespaceManager(blockEncodingSerde, featuresConfig, this);
        this.functionNamespaceManagers.put(BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE.getCatalogName(), this.builtInFunctionNamespaceManager);
        this.functionInvokerProvider = new FunctionInvokerProvider(this);
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        this.builtInTypeRegistry = new TypeRegistry(types, featuresConfig, this);
        transactionManager.registerFunctionNamespaceManager(BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE.getCatalogName(), this.builtInFunctionNamespaceManager);
        this.functionCache = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.resolveBuiltInFunction(((FunctionResolutionCacheKey)key).functionName, TypeSignatureProvider.fromTypeSignatures(((FunctionResolutionCacheKey)key).parameterTypes))));
        this.cacheStatsMBean = new CacheStatsMBean(this.functionCache);
    }

    public static FunctionAndTypeManager createTestFunctionAndTypeManager() {
        return new FunctionAndTypeManager(InMemoryTransactionManager.createTestTransactionManager(), new BlockEncodingManager(new BlockEncoding[0]), new FeaturesConfig(), new HandleResolver(), (Set<Type>)ImmutableSet.of());
    }

    @Managed
    @Nested
    public CacheStatsMBean getFunctionResolutionCacheStats() {
        return this.cacheStatsMBean;
    }

    public void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties) {
        Objects.requireNonNull(functionNamespaceManagerName, "functionNamespaceManagerName is null");
        FunctionNamespaceManagerFactory factory = this.functionNamespaceManagerFactories.get(functionNamespaceManagerName);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"No factory for function namespace manager %s", (Object)functionNamespaceManagerName);
        FunctionNamespaceManager functionNamespaceManager = factory.create(catalogName, properties);
        this.transactionManager.registerFunctionNamespaceManager(catalogName, functionNamespaceManager);
        if (this.functionNamespaceManagers.putIfAbsent(catalogName, (FunctionNamespaceManager<? extends SqlFunction>)functionNamespaceManager) != null) {
            throw new IllegalArgumentException(String.format("Function namespace manager is already registered for catalog [%s]", catalogName));
        }
    }

    @VisibleForTesting
    public void addFunctionNamespace(String catalogName, FunctionNamespaceManager functionNamespaceManager) {
        this.transactionManager.registerFunctionNamespaceManager(catalogName, functionNamespaceManager);
        if (this.functionNamespaceManagers.putIfAbsent(catalogName, (FunctionNamespaceManager<? extends SqlFunction>)functionNamespaceManager) != null) {
            throw new IllegalArgumentException(String.format("Function namespace manager is already registered for catalog [%s]", catalogName));
        }
    }

    public FunctionInvokerProvider getFunctionInvokerProvider() {
        return this.functionInvokerProvider;
    }

    public void addFunctionNamespaceFactory(FunctionNamespaceManagerFactory factory) {
        if (this.functionNamespaceManagerFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Resource group configuration manager '%s' is already registered", factory.getName()));
        }
        this.handleResolver.addFunctionNamespace(factory.getName(), factory.getHandleResolver());
    }

    public void registerBuiltInFunctions(List<? extends SqlFunction> functions) {
        this.builtInFunctionNamespaceManager.registerBuiltInFunctions(functions);
    }

    public List<SqlFunction> listFunctions(Session session) {
        Object managers = SystemSessionProperties.isListBuiltInFunctionsOnly(session) ? ImmutableSet.of((Object)this.builtInFunctionNamespaceManager) : this.functionNamespaceManagers.values();
        return (List)managers.stream().flatMap(manager -> manager.listFunctions().stream()).filter(function -> function.getVisibility() == SqlFunctionVisibility.PUBLIC || function.getVisibility() == SqlFunctionVisibility.EXPERIMENTAL && SystemSessionProperties.isExperimentalFunctionsEnabled(session)).collect(ImmutableList.toImmutableList());
    }

    public Collection<? extends SqlFunction> getFunctions(Optional<TransactionId> transactionId, QualifiedFunctionName functionName) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getFunctionNamespace());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName));
        }
        Optional<FunctionNamespaceTransactionHandle> transactionHandle = transactionId.map(id -> this.transactionManager.getFunctionNamespaceTransaction((TransactionId)id, functionName.getFunctionNamespace().getCatalogName()));
        return functionNamespaceManager.get().getFunctions(transactionHandle, functionName);
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(function.getSignature().getName().getFunctionNamespace());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Cannot create function in function namespace: %s", function.getFunctionId().getFunctionName().getFunctionNamespace()));
        }
        functionNamespaceManager.get().createFunction(function, replace);
    }

    public void alterFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getFunctionNamespace());
        if (!functionNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName));
        }
        functionNamespaceManager.get().alterFunction(functionName, parameterTypes, alterRoutineCharacteristics);
    }

    public void dropFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getFunctionNamespace());
        if (functionNamespaceManager.isPresent()) {
            functionNamespaceManager.get().dropFunction(functionName, parameterTypes, exists);
        } else if (!exists) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s", functionName.getFunctionNamespace()));
        }
    }

    public void addType(Type type) {
        this.builtInTypeRegistry.addType(type);
    }

    public void addParametricType(ParametricType parametricType) {
        this.builtInTypeRegistry.addParametricType(parametricType);
    }

    public static QualifiedFunctionName qualifyFunctionName(QualifiedName name) {
        if (!name.getPrefix().isPresent()) {
            return QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name.getSuffix());
        }
        if (name.getOriginalParts().size() != 3) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Non-builtin functions must be referenced by 'catalog.schema.function_name', found: %s", name));
        }
        return QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName((String)name.getOriginalParts().get(0), (String)name.getOriginalParts().get(1)), (String)((String)name.getOriginalParts().get(2)));
    }

    public FunctionHandle resolveFunction(Optional<TransactionId> transactionId, QualifiedFunctionName functionName, List<TypeSignatureProvider> parameterTypes) {
        if (functionName.getFunctionNamespace().equals((Object)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE) && parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency)) {
            return this.lookupCachedFunction(functionName, parameterTypes);
        }
        return this.resolveFunctionInternal(transactionId, functionName, parameterTypes);
    }

    public Type getType(TypeSignature signature) {
        return this.builtInTypeRegistry.getType(signature);
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
        return this.builtInTypeRegistry.getParameterizedType(baseTypeName, typeParameters);
    }

    public List<Type> getTypes() {
        return this.builtInTypeRegistry.getTypes();
    }

    public Collection<ParametricType> getParametricTypes() {
        return this.builtInTypeRegistry.getParametricTypes();
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        return this.builtInTypeRegistry.getCommonSuperType(firstType, secondType);
    }

    public boolean canCoerce(Type actualType, Type expectedType) {
        return this.builtInTypeRegistry.canCoerce(actualType, expectedType);
    }

    public boolean isTypeOnlyCoercion(Type actualType, Type expectedType) {
        return this.builtInTypeRegistry.isTypeOnlyCoercion(actualType, expectedType);
    }

    public Optional<Type> coerceTypeBase(Type sourceType, String resultTypeBase) {
        return this.builtInTypeRegistry.coerceTypeBase(sourceType, resultTypeBase);
    }

    public FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getFunctionNamespace());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for '%s'", (Object)functionHandle.getFunctionNamespace());
        return functionNamespaceManager.get().getFunctionMetadata(functionHandle);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getFunctionNamespace());
        Preconditions.checkArgument((boolean)functionNamespaceManager.isPresent(), (String)"Cannot find function namespace for '%s'", (Object)functionHandle.getFunctionNamespace());
        return functionNamespaceManager.get().getScalarFunctionImplementation(functionHandle);
    }

    public CompletableFuture<Block> executeFunction(FunctionHandle functionHandle, Page inputPage, List<Integer> channels) {
        Optional<FunctionNamespaceManager<? extends SqlFunction>> functionNamespaceManager = this.getServingFunctionNamespaceManager(functionHandle.getFunctionNamespace());
        Preconditions.checkState((boolean)functionNamespaceManager.isPresent(), (Object)String.format("FunctionHandle %s should have a serving function namespace", functionHandle));
        return functionNamespaceManager.get().executeFunction(functionHandle, inputPage, channels, (TypeManager)this);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInFunctionNamespaceManager.getWindowFunctionImplementation(functionHandle);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInFunctionNamespaceManager.getAggregateFunctionImplementation(functionHandle);
    }

    public BuiltInScalarFunctionImplementation getBuiltInScalarFunctionImplementation(FunctionHandle functionHandle) {
        return (BuiltInScalarFunctionImplementation)this.builtInFunctionNamespaceManager.getScalarFunctionImplementation(functionHandle);
    }

    @VisibleForTesting
    public List<SqlFunction> listOperators() {
        Set operatorNames = (Set)Arrays.asList(OperatorType.values()).stream().map(OperatorType::getFunctionName).collect(ImmutableSet.toImmutableSet());
        return (List)this.builtInFunctionNamespaceManager.listFunctions().stream().filter(function -> operatorNames.contains(function.getSignature().getName())).collect(ImmutableList.toImmutableList());
    }

    public FunctionHandle resolveOperator(OperatorType operatorType, List<TypeSignatureProvider> argumentTypes) {
        try {
            return this.resolveFunction(Optional.empty(), operatorType.getFunctionName(), argumentTypes);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, (List)argumentTypes.stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList()));
            }
            throw e;
        }
    }

    public FunctionHandle lookupFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        QualifiedFunctionName functionName = FunctionAndTypeManager.qualifyFunctionName(QualifiedName.of((String)name));
        if (parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency)) {
            return this.lookupCachedFunction(functionName, parameterTypes);
        }
        Collection<SqlFunction> candidates = this.builtInFunctionNamespaceManager.getFunctions(Optional.empty(), functionName);
        return this.lookupFunction(this.builtInFunctionNamespaceManager, Optional.empty(), functionName, parameterTypes, candidates);
    }

    public FunctionHandle lookupCast(CastType castType, TypeSignature fromType, TypeSignature toType) {
        Signature signature = new Signature(castType.getCastName(), FunctionKind.SCALAR, Collections.emptyList(), Collections.emptyList(), toType, Collections.singletonList(fromType), false);
        try {
            this.builtInFunctionNamespaceManager.getScalarFunctionImplementation(signature);
        }
        catch (PrestoException e) {
            if (castType.isOperatorType() && e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(CastType.toOperatorType(castType), (List<TypeSignature>)ImmutableList.of((Object)fromType), toType);
            }
            throw e;
        }
        return this.builtInFunctionNamespaceManager.getFunctionHandle(Optional.empty(), signature);
    }

    private FunctionHandle resolveFunctionInternal(Optional<TransactionId> transactionId, QualifiedFunctionName functionName, List<TypeSignatureProvider> parameterTypes) {
        FunctionNamespaceManager functionNamespaceManager = this.getServingFunctionNamespaceManager(functionName.getFunctionNamespace()).orElse(null);
        if (functionNamespaceManager == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, this.constructFunctionNotFoundErrorMessage(functionName, parameterTypes, (Collection<? extends SqlFunction>)ImmutableList.of()));
        }
        Optional<FunctionNamespaceTransactionHandle> transactionHandle = transactionId.map(id -> this.transactionManager.getFunctionNamespaceTransaction((TransactionId)id, functionName.getFunctionNamespace().getCatalogName()));
        Collection candidates = functionNamespaceManager.getFunctions(transactionHandle, functionName);
        try {
            return this.lookupFunction(functionNamespaceManager, transactionHandle, functionName, parameterTypes, candidates);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() != StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw e;
            }
            Optional<Signature> match = this.matchFunctionWithCoercion(candidates, parameterTypes);
            if (match.isPresent()) {
                return functionNamespaceManager.getFunctionHandle(transactionHandle, match.get());
            }
            if (functionName.getFunctionName().startsWith("$literal$")) {
                String typeName = functionName.getFunctionName().substring("$literal$".length());
                Type type = this.getType(TypeSignature.parseTypeSignature((String)typeName));
                Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", parameterTypes);
                return new BuiltInFunctionHandle(LiteralEncoder.getMagicLiteralFunctionSignature(type));
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, this.constructFunctionNotFoundErrorMessage(functionName, parameterTypes, candidates));
        }
    }

    private FunctionHandle resolveBuiltInFunction(QualifiedFunctionName functionName, List<TypeSignatureProvider> parameterTypes) {
        Preconditions.checkArgument((boolean)functionName.getFunctionNamespace().equals((Object)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE), (Object)"Expect built-in functions");
        Preconditions.checkArgument((boolean)parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency), (Object)"Expect parameter types not to have dependency");
        return this.resolveFunctionInternal(Optional.empty(), functionName, parameterTypes);
    }

    private FunctionHandle lookupCachedFunction(QualifiedFunctionName functionName, List<TypeSignatureProvider> parameterTypes) {
        try {
            return (FunctionHandle)this.functionCache.getUnchecked((Object)new FunctionResolutionCacheKey(functionName, parameterTypes));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof PrestoException) {
                throw (PrestoException)e.getCause();
            }
            throw e;
        }
    }

    private FunctionHandle lookupFunction(FunctionNamespaceManager<?> functionNamespaceManager, Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, QualifiedFunctionName functionName, List<TypeSignatureProvider> parameterTypes, Collection<? extends SqlFunction> candidates) {
        List<SqlFunction> exactCandidates = candidates.stream().filter(function -> function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        Optional<Signature> match = this.matchFunctionExact(exactCandidates, parameterTypes);
        if (match.isPresent()) {
            return functionNamespaceManager.getFunctionHandle(transactionHandle, match.get());
        }
        List<SqlFunction> genericCandidates = candidates.stream().filter(function -> !function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        match = this.matchFunctionExact(genericCandidates, parameterTypes);
        if (match.isPresent()) {
            return functionNamespaceManager.getFunctionHandle(transactionHandle, match.get());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, this.constructFunctionNotFoundErrorMessage(functionName, parameterTypes, candidates));
    }

    private Optional<FunctionNamespaceManager<? extends SqlFunction>> getServingFunctionNamespaceManager(CatalogSchemaName functionNamespace) {
        return Optional.ofNullable(this.functionNamespaceManagers.get(functionNamespace.getCatalogName()));
    }

    /*
     * WARNING - void declaration
     */
    private String constructFunctionNotFoundErrorMessage(QualifiedFunctionName functionName, List<TypeSignatureProvider> parameterTypes, Collection<? extends SqlFunction> candidates) {
        void var7_10;
        String name = this.toConciseFunctionName(functionName);
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (SqlFunction sqlFunction : candidates) {
            expectedParameters.add(String.format("%s(%s) %s", name, Joiner.on((String)", ").join((Iterable)sqlFunction.getSignature().getArgumentTypes()), Joiner.on((String)", ").join((Iterable)sqlFunction.getSignature().getTypeVariableConstraints())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String string = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            String string2 = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        return var7_10;
    }

    private String toConciseFunctionName(QualifiedFunctionName functionName) {
        if (functionName.getFunctionNamespace().equals((Object)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE)) {
            return functionName.getFunctionName();
        }
        return functionName.toString();
    }

    private Optional<Signature> matchFunctionExact(List<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, false);
    }

    private Optional<Signature> matchFunctionWithCoercion(Collection<? extends SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, true);
    }

    private Optional<Signature> matchFunction(Collection<? extends SqlFunction> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            return Optional.of(((ApplicableFunction)Iterables.getOnlyElement(applicableFunctions)).getBoundSignature());
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.getBoundSignature().toString());
            errorMessageBuilder.append("\n");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Collection<? extends SqlFunction> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (SqlFunction sqlFunction : candidates) {
            Signature declaredSignature = sqlFunction.getSignature();
            Optional<Signature> boundSignature = new SignatureBinder(this, declaredSignature, allowCoercion).bind(actualParameters);
            if (!boundSignature.isPresent()) continue;
            applicableFunctions.add((Object)new ApplicableFunction(declaredSignature, boundSignature.get(), sqlFunction.isCalledOnNullInput()));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = FunctionAndTypeManager.toTypes(parameters, this);
        if (!optionalParameterTypes.isPresent()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionAndTypeManager.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && this.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(current, representative) && !this.isMoreSpecificThan(representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals((Object)UnknownType.UNKNOWN));
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List<Type> boundTypes = TypeUtils.resolveTypes(applicableFunction.getBoundSignature().getArgumentTypes(), this);
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (boundTypes.get(i).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.getType(function.getBoundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> this.returnsNullOnGivenInputTypes((ApplicableFunction)x, parameters));
    }

    private boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        Signature boundSignature = applicableFunction.getBoundSignature();
        FunctionKind functionKind = boundSignature.getKind();
        if (functionKind != FunctionKind.SCALAR) {
            return true;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Type parameterType = parameterTypes.get(i);
            if (!parameterType.equals((Object)UnknownType.UNKNOWN) || !applicableFunction.isCalledOnNullInput()) continue;
            return false;
        }
        return true;
    }

    private static Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders, TypeManager typeManager) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)typeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        List<TypeSignatureProvider> resolvedTypes = TypeSignatureProvider.fromTypeSignatures(left.getBoundSignature().getArgumentTypes());
        Optional<BoundVariables> boundVariables = new SignatureBinder(this, right.getDeclaredSignature(), true).bindVariables(resolvedTypes);
        return boundVariables.isPresent();
    }

    private static class FunctionResolutionCacheKey {
        private final QualifiedFunctionName functionName;
        private final List<TypeSignature> parameterTypes;

        private FunctionResolutionCacheKey(QualifiedFunctionName functionName, List<TypeSignatureProvider> parameterTypes) {
            Preconditions.checkArgument((boolean)parameterTypes.stream().noneMatch(TypeSignatureProvider::hasDependency), (Object)"Only type signatures without dependency can be cached");
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.parameterTypes = (List)Objects.requireNonNull(parameterTypes, "parameterTypes is null").stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList());
        }

        public int hashCode() {
            return Objects.hash(this.functionName, this.parameterTypes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionResolutionCacheKey other = (FunctionResolutionCacheKey)obj;
            return Objects.equals(this.functionName, other.functionName) && Objects.equals(this.parameterTypes, other.parameterTypes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("parameterTypes", this.parameterTypes).toString();
        }
    }

    private static class ApplicableFunction {
        private final Signature declaredSignature;
        private final Signature boundSignature;
        private final boolean calledOnNullInput;

        private ApplicableFunction(Signature declaredSignature, Signature boundSignature, boolean calledOnNullInput) {
            this.declaredSignature = declaredSignature;
            this.boundSignature = boundSignature;
            this.calledOnNullInput = calledOnNullInput;
        }

        public Signature getDeclaredSignature() {
            return this.declaredSignature;
        }

        public Signature getBoundSignature() {
            return this.boundSignature;
        }

        public boolean isCalledOnNullInput() {
            return this.calledOnNullInput;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.declaredSignature).add("boundSignature", (Object)this.boundSignature).add("calledOnNullInput", this.calledOnNullInput).toString();
        }
    }
}

