/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.http.client.FullJsonResponseHandler;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.metadata.RemoteNodeState;
import com.facebook.presto.spi.NodeState;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HttpRemoteNodeState
implements RemoteNodeState {
    private static final Logger log = Logger.get(HttpRemoteNodeState.class);
    private final HttpClient httpClient;
    private final URI stateInfoUri;
    private final AtomicReference<Optional<NodeState>> nodeState = new AtomicReference(Optional.empty());
    private final AtomicReference<Future<?>> future = new AtomicReference();
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final AtomicLong lastWarningLogged = new AtomicLong();

    public HttpRemoteNodeState(HttpClient httpClient, URI stateInfoUri) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.stateInfoUri = Objects.requireNonNull(stateInfoUri, "stateInfoUri is null");
    }

    @Override
    public Optional<NodeState> getNodeState() {
        return this.nodeState.get();
    }

    @Override
    public synchronized void asyncRefresh() {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (Duration.nanosSince((long)this.lastWarningLogged.get()).toMillis() > 1000L && sinceUpdate.toMillis() > 10000L && this.future.get() != null) {
            log.warn("Node state update request to %s has not returned in %s", new Object[]{this.stateInfoUri, sinceUpdate.toString(TimeUnit.SECONDS)});
            this.lastWarningLogged.set(System.nanoTime());
        }
        if (sinceUpdate.toMillis() > 1000L && this.future.get() == null) {
            Request request = Request.Builder.prepareGet().setUri(this.stateInfoUri).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).build();
            final HttpClient.HttpResponseFuture responseFuture = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(NodeState.class)));
            this.future.compareAndSet((Future<?>)null, (Future<?>)responseFuture);
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<FullJsonResponseHandler.JsonResponse<NodeState>>(){

                public void onSuccess(@Nullable FullJsonResponseHandler.JsonResponse<NodeState> result) {
                    HttpRemoteNodeState.this.lastUpdateNanos.set(System.nanoTime());
                    HttpRemoteNodeState.this.future.compareAndSet(responseFuture, null);
                    if (result != null) {
                        if (result.hasValue()) {
                            HttpRemoteNodeState.this.nodeState.set(Optional.ofNullable(result.getValue()));
                        }
                        if (result.getStatusCode() != HttpStatus.OK.code()) {
                            log.warn("Error fetching node state from %s returned status %d: %s", new Object[]{HttpRemoteNodeState.this.stateInfoUri, result.getStatusCode(), result.getStatusMessage()});
                            return;
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    log.warn("Error fetching node state from %s: %s", new Object[]{HttpRemoteNodeState.this.stateInfoUri, t.getMessage()});
                    HttpRemoteNodeState.this.lastUpdateNanos.set(System.nanoTime());
                    HttpRemoteNodeState.this.future.compareAndSet(responseFuture, null);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

