/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Objects;
import java.util.OptionalInt;

public class InternalNode
implements Node {
    private final String nodeIdentifier;
    private final URI internalUri;
    private final OptionalInt thriftPort;
    private final NodeVersion nodeVersion;
    private final boolean coordinator;

    public InternalNode(String nodeIdentifier, URI internalUri, NodeVersion nodeVersion, boolean coordinator) {
        this(nodeIdentifier, internalUri, OptionalInt.empty(), nodeVersion, coordinator);
    }

    public InternalNode(String nodeIdentifier, URI internalUri, OptionalInt thriftPort, NodeVersion nodeVersion, boolean coordinator) {
        nodeIdentifier = Strings.emptyToNull((String)Strings.nullToEmpty((String)nodeIdentifier).trim());
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null or empty");
        this.internalUri = Objects.requireNonNull(internalUri, "internalUri is null");
        this.thriftPort = Objects.requireNonNull(thriftPort, "thriftPort is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.coordinator = coordinator;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public String getHost() {
        return this.internalUri.getHost();
    }

    @Deprecated
    public URI getHttpUri() {
        return this.getInternalUri();
    }

    public OptionalInt getThriftPort() {
        return this.thriftPort;
    }

    public URI getInternalUri() {
        return this.internalUri;
    }

    public HostAddress getHostAndPort() {
        return HostAddress.fromUri((URI)this.internalUri);
    }

    public String getVersion() {
        return this.nodeVersion.getVersion();
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InternalNode o = (InternalNode)obj;
        return this.nodeIdentifier.equals(o.nodeIdentifier);
    }

    public int hashCode() {
        return this.nodeIdentifier.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeIdentifier", (Object)this.nodeIdentifier).add("internalUri", (Object)this.internalUri).add("thriftPort", (Object)this.thriftPort).add("nodeVersion", (Object)this.nodeVersion).toString();
    }
}

