/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.FileFragmentResultCacheConfig;
import com.facebook.presto.operator.FragmentCacheStats;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.sql.planner.CanonicalPlanFragment;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.Futures;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class FileFragmentResultCacheManager
implements FragmentResultCacheManager {
    private static final Logger log = Logger.get(FileFragmentResultCacheManager.class);
    private final Path baseDirectory;
    private final long maxInFlightBytes;
    private final PagesSerde pagesSerde;
    private final FragmentCacheStats fragmentCacheStats;
    private final ExecutorService flushExecutor;
    private final ExecutorService removalExecutor;
    private final Cache<CacheKey, Path> cache;

    @Inject
    public FileFragmentResultCacheManager(FileFragmentResultCacheConfig cacheConfig, BlockEncodingSerde blockEncodingSerde, FragmentCacheStats fragmentCacheStats, ExecutorService flushExecutor, ExecutorService removalExecutor) {
        Objects.requireNonNull(cacheConfig, "cacheConfig is null");
        Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.baseDirectory = Paths.get(cacheConfig.getBaseDirectory());
        this.maxInFlightBytes = cacheConfig.getMaxInFlightSize().toBytes();
        this.pagesSerde = new PagesSerdeFactory(blockEncodingSerde, cacheConfig.isBlockEncodingCompressionEnabled()).createPagesSerde();
        this.fragmentCacheStats = Objects.requireNonNull(fragmentCacheStats, "fragmentCacheStats is null");
        this.flushExecutor = Objects.requireNonNull(flushExecutor, "flushExecutor is null");
        this.removalExecutor = Objects.requireNonNull(removalExecutor, "removalExecutor is null");
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getMaxCachedEntries()).expireAfterAccess(cacheConfig.getCacheTtl().toMillis(), TimeUnit.MILLISECONDS).removalListener((RemovalListener)new CacheRemovalListener()).recordStats().build();
        File target = new File(this.baseDirectory.toUri());
        if (!target.exists()) {
            try {
                Files.createDirectories(target.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "cannot create cache directory " + target, (Throwable)e);
            }
        } else {
            File[] files = target.listFiles();
            if (files == null) {
                return;
            }
            this.removalExecutor.submit(() -> Arrays.stream(files).forEach(file -> {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
        }
    }

    @Override
    public Future<?> put(CanonicalPlanFragment plan, Split split, List<Page> result) {
        CacheKey key = new CacheKey(plan, split.getSplitIdentifier());
        long resultSize = FileFragmentResultCacheManager.getPagesSize(result);
        if (this.fragmentCacheStats.getInFlightBytes() + resultSize > this.maxInFlightBytes || this.cache.getIfPresent((Object)key) != null) {
            return Futures.immediateFuture(null);
        }
        this.fragmentCacheStats.addInFlightBytes(resultSize);
        Path path = this.baseDirectory.resolve(UUID.randomUUID().toString().replaceAll("-", "_"));
        return this.flushExecutor.submit(() -> this.cachePages(key, path, result));
    }

    private static long getPagesSize(List<Page> pages) {
        return pages.stream().mapToLong(Page::getSizeInBytes).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePages(CacheKey key, Path path, List<Page> pages) {
        try {
            Files.createFile(path, new FileAttribute[0]);
            try (OutputStreamSliceOutput output = new OutputStreamSliceOutput(Files.newOutputStream(path, StandardOpenOption.APPEND));){
                PagesSerdeUtil.writePages((PagesSerde)this.pagesSerde, (SliceOutput)output, pages.iterator());
                this.cache.put((Object)key, (Object)path);
            }
            catch (IOException | UncheckedIOException e) {
                log.warn((Throwable)e, "%s encountered an error while writing to path %s", new Object[]{Thread.currentThread().getName(), path});
                FileFragmentResultCacheManager.tryDeleteFile(path);
            }
        }
        catch (IOException | UncheckedIOException e) {
            log.warn((Throwable)e, "%s encountered an error while writing to path %s", new Object[]{Thread.currentThread().getName(), path});
            FileFragmentResultCacheManager.tryDeleteFile(path);
        }
        finally {
            this.fragmentCacheStats.addInFlightBytes(-FileFragmentResultCacheManager.getPagesSize(pages));
        }
    }

    private static void tryDeleteFile(Path path) {
        try {
            File file = new File(path.toUri());
            if (file.exists()) {
                Files.delete(file.toPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Optional<Iterator<Page>> get(CanonicalPlanFragment plan, Split split) {
        CacheKey key = new CacheKey(plan, split.getSplitIdentifier());
        Path path = (Path)this.cache.getIfPresent((Object)key);
        if (path == null) {
            this.fragmentCacheStats.incrementCacheMiss();
            return Optional.empty();
        }
        try {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            Iterator result = PagesSerdeUtil.readPages((PagesSerde)this.pagesSerde, (SliceInput)new InputStreamSliceInput(inputStream));
            this.fragmentCacheStats.incrementCacheHit();
            return Optional.of(FileFragmentResultCacheManager.closeWhenExhausted(result, inputStream));
        }
        catch (IOException | UncheckedIOException e) {
            this.fragmentCacheStats.incrementCacheMiss();
            return Optional.empty();
        }
    }

    private static <T> Iterator<T> closeWhenExhausted(final Iterator<T> iterator, final Closeable resource) {
        Objects.requireNonNull(iterator, "iterator is null");
        Objects.requireNonNull(resource, "resource is null");
        return new AbstractIterator<T>(){

            protected T computeNext() {
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                try {
                    resource.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return this.endOfData();
            }
        };
    }

    private class CacheRemovalListener
    implements RemovalListener<CacheKey, Path> {
        private CacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<CacheKey, Path> notification) {
            FileFragmentResultCacheManager.this.removalExecutor.submit(() -> FileFragmentResultCacheManager.tryDeleteFile((Path)notification.getValue()));
        }
    }

    public static class CacheKey {
        private final CanonicalPlanFragment plan;
        private final Split.SplitIdentifier splitIdentifier;

        public CacheKey(CanonicalPlanFragment plan, Split.SplitIdentifier splitIdentifier) {
            this.plan = Objects.requireNonNull(plan, "plan is null");
            this.splitIdentifier = Objects.requireNonNull(splitIdentifier, "splitIdentifier is null");
        }

        public CanonicalPlanFragment getPlan() {
            return this.plan;
        }

        public Split.SplitIdentifier getSplitIdentifier() {
            return this.splitIdentifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.plan, cacheKey.plan) && Objects.equals(this.splitIdentifier, cacheKey.splitIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.plan, this.splitIdentifier);
        }
    }
}

