/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.ChannelSet;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;

public class HashSemiJoinOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int probeJoinChannel;
    private final ListenableFuture<ChannelSet> channelSetFuture;
    private ChannelSet channelSet;
    private Page outputPage;
    private boolean finishing;

    public HashSemiJoinOperator(OperatorContext operatorContext, SetBuilderOperator.SetSupplier channelSetFuture, int probeJoinChannel) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(channelSetFuture, "hashProvider is null");
        Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
        this.channelSetFuture = channelSetFuture.getChannelSet();
        this.probeJoinChannel = probeJoinChannel;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.channelSetFuture;
    }

    @Override
    public boolean needsInput() {
        if (this.finishing || this.outputPage != null) {
            return false;
        }
        if (this.channelSet == null) {
            this.channelSet = MoreFutures.tryGetFutureValue(this.channelSetFuture).orElse(null);
        }
        return this.channelSet != null;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.channelSet != null ? 1 : 0) != 0, (Object)"Set has not been built yet");
        Preconditions.checkState((this.outputPage == null ? 1 : 0) != 0, (Object)"Operator still has pending output");
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(page.getPositionCount());
        Page probeJoinPage = page.extractChannel(this.probeJoinChannel);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (probeJoinPage.getBlock(0).isNull(position)) {
                if (this.channelSet.isEmpty()) {
                    BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
                    continue;
                }
                blockBuilder.appendNull();
                continue;
            }
            boolean contains = this.channelSet.contains(position, probeJoinPage);
            if (!contains && this.channelSet.containsNull()) {
                blockBuilder.appendNull();
                continue;
            }
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, contains);
        }
        this.outputPage = page.appendColumn(blockBuilder.build());
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class HashSemiJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final SetBuilderOperator.SetSupplier setSupplier;
        private final List<Type> probeTypes;
        private final int probeJoinChannel;
        private boolean closed;

        public HashSemiJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, SetBuilderOperator.SetSupplier setSupplier, List<? extends Type> probeTypes, int probeJoinChannel) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.setSupplier = setSupplier;
            this.probeTypes = ImmutableList.copyOf(probeTypes);
            Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
            this.probeJoinChannel = probeJoinChannel;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashSemiJoinOperator.class.getSimpleName());
            return new HashSemiJoinOperator(operatorContext, this.setSupplier, this.probeJoinChannel);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new HashSemiJoinOperatorFactory(this.operatorId, this.planNodeId, this.setSupplier, this.probeTypes, this.probeJoinChannel);
        }
    }
}

