/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;

public class InterpretedHashGenerator
implements HashGenerator {
    private final List<Type> hashChannelTypes;
    private final int[] hashChannels;

    public InterpretedHashGenerator(List<Type> hashChannelTypes, List<Integer> hashChannels) {
        this(hashChannelTypes, Objects.requireNonNull(hashChannels).stream().mapToInt(i -> i).toArray());
    }

    public InterpretedHashGenerator(List<Type> hashChannelTypes, int[] hashChannels) {
        this.hashChannels = Objects.requireNonNull(hashChannels, "hashChannels is null");
        this.hashChannelTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannelTypes, "hashChannelTypes is null"));
        Preconditions.checkArgument((hashChannelTypes.size() == hashChannels.length ? 1 : 0) != 0);
    }

    @Override
    public long hashPosition(int position, Page page) {
        return this.hashPosition(position, arg_0 -> ((Page)page).getBlock(arg_0));
    }

    public long hashPosition(int position, IntFunction<Block> blockProvider) {
        long result = 0L;
        for (int i = 0; i < this.hashChannels.length; ++i) {
            Type type = this.hashChannelTypes.get(i);
            result = CombineHashFunction.getHash(result, TypeUtils.hashPosition(type, blockProvider.apply(this.hashChannels[i]), position));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashChannelTypes", this.hashChannelTypes).add("hashChannels", (Object)this.hashChannels).toString();
    }
}

