/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class RemoteProjectOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final FunctionAndTypeManager functionAndTypeManager;
    private final List<RowExpression> projections;
    private final CompletableFuture<Block>[] result;
    private boolean finishing;

    private RemoteProjectOperator(OperatorContext operatorContext, FunctionAndTypeManager functionAndTypeManager, List<RowExpression> projections) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.projections = ImmutableList.copyOf((Collection)Objects.requireNonNull(projections, "projections is null"));
        this.result = new CompletableFuture[projections.size()];
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && !this.processingPage();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkState((!this.processingPage() ? 1 : 0) != 0, (Object)"Still processing previous input");
        Objects.requireNonNull(page, "page is null");
        for (int channel = 0; channel < this.projections.size(); ++channel) {
            RowExpression projection = this.projections.get(channel);
            if (projection instanceof InputReferenceExpression) {
                this.result[channel] = CompletableFuture.completedFuture(page.getBlock(((InputReferenceExpression)projection).getField()));
                continue;
            }
            if (projection instanceof CallExpression) {
                CallExpression remoteCall = (CallExpression)projection;
                this.result[channel] = this.functionAndTypeManager.executeFunction(remoteCall.getFunctionHandle(), page, (List)remoteCall.getArguments().stream().map(InputReferenceExpression.class::cast).map(InputReferenceExpression::getField).collect(ImmutableList.toImmutableList()));
                continue;
            }
            Preconditions.checkState((boolean)(projection instanceof ConstantExpression), (Object)String.format("Does not expect expression type %s", projection.getClass()));
        }
    }

    @Override
    public Page getOutput() {
        if (this.resultReady()) {
            Block[] blocks = new Block[this.result.length];
            try {
                for (int i = 0; i < blocks.length; ++i) {
                    blocks[i] = this.result[i].get();
                }
                Page output = new Page(blocks);
                Arrays.fill(this.result, null);
                return output;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    Throwables.throwIfUnchecked((Throwable)cause);
                    throw new RuntimeException(cause);
                }
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && !this.processingPage();
    }

    private boolean processingPage() {
        for (int i = 0; i < this.result.length; ++i) {
            if (this.result[i] == null) continue;
            return true;
        }
        return false;
    }

    private boolean resultReady() {
        for (int i = 0; i < this.result.length; ++i) {
            if (this.result[i] != null && this.result[i].isDone()) continue;
            return false;
        }
        return true;
    }

    public static class RemoteProjectOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final FunctionAndTypeManager functionAndTypeManager;
        private final List<RowExpression> projections;
        private boolean closed;

        public RemoteProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, FunctionAndTypeManager functionAndTypeManager, List<RowExpression> projections) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
            this.projections = ImmutableList.copyOf((Collection)Objects.requireNonNull(projections, "projections is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, RemoteProjectOperator.class.getSimpleName());
            return new RemoteProjectOperator(operatorContext, this.functionAndTypeManager, this.projections);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new RemoteProjectOperatorFactory(this.operatorId, this.planNodeId, this.functionAndTypeManager, this.projections);
        }
    }
}

