/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.TableCommitContext;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class TableWriterUtils {
    public static final int ROW_COUNT_CHANNEL = 0;
    public static final int FRAGMENT_CHANNEL = 1;
    public static final int CONTEXT_CHANNEL = 2;
    public static final int STATS_START_CHANNEL = 3;

    private TableWriterUtils() {
    }

    public static Optional<Page> extractStatisticsRows(Page page) {
        int statisticsPositionCount = 0;
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!TableWriterUtils.isStatisticsPosition(page, position)) continue;
            ++statisticsPositionCount;
        }
        if (statisticsPositionCount == 0) {
            return Optional.empty();
        }
        if (statisticsPositionCount == page.getPositionCount()) {
            return Optional.of(page);
        }
        int selectedPositionsIndex = 0;
        int[] selectedPositions = new int[statisticsPositionCount];
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!TableWriterUtils.isStatisticsPosition(page, position)) continue;
            selectedPositions[selectedPositionsIndex] = position;
            ++selectedPositionsIndex;
        }
        Block[] blocks = new Block[page.getChannelCount()];
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            blocks[channel] = page.getBlock(channel).getPositions(selectedPositions, 0, statisticsPositionCount);
        }
        return Optional.of(new Page(statisticsPositionCount, blocks));
    }

    private static boolean isStatisticsPosition(Page page, int position) {
        return page.getBlock(0).isNull(position) && page.getBlock(1).isNull(position);
    }

    public static Page createStatisticsPage(List<Type> types, Page aggregationOutput, Slice tableCommitContext) {
        int positionCount = aggregationOutput.getPositionCount();
        Block[] outputBlocks = new Block[types.size()];
        for (int channel = 0; channel < types.size(); ++channel) {
            if (channel < 3) {
                if (channel == 2) {
                    outputBlocks[channel] = RunLengthEncodedBlock.create((Type)types.get(channel), (Object)tableCommitContext, (int)positionCount);
                    continue;
                }
                outputBlocks[channel] = RunLengthEncodedBlock.create((Type)types.get(channel), null, (int)positionCount);
                continue;
            }
            outputBlocks[channel] = aggregationOutput.getBlock(channel - 3);
        }
        return new Page(positionCount, outputBlocks);
    }

    public static TableCommitContext getTableCommitContext(Page page, JsonCodec<TableCommitContext> tableCommitContextCodec) {
        Preconditions.checkState((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"page is empty");
        Block operatorExecutionContextBlock = page.getBlock(2);
        TableCommitContext context = (TableCommitContext)tableCommitContextCodec.fromJson(operatorExecutionContextBlock.getSlice(0, 0, operatorExecutionContextBlock.getSliceLength(0)).getBytes());
        return Objects.requireNonNull(context, "context is null");
    }
}

