/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.operator.aggregation.HyperLogLogUtils;
import com.facebook.presto.operator.aggregation.state.BooleanDistinctState;
import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="approx_distinct")
public final class ApproximateCountDistinctAggregation {
    private ApproximateCountDistinctAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @BlockPosition @SqlType(value="unknown") Block block, @BlockIndex int index, @SqlType(value="double") double maxStandardError) {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") long value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = HyperLogLogUtils.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") double value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = HyperLogLogUtils.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") Slice value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = HyperLogLogUtils.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    public static void input(BooleanDistinctState state, @SqlType(value="boolean") boolean value, @SqlType(value="double") double maxStandardError) {
        state.setByte((byte)(state.getByte() | (value ? 1 : 2)));
    }

    @CombineFunction
    public static void combineState(@AggregationState HyperLogLogState state, @AggregationState HyperLogLogState otherState) {
        HyperLogLogUtils.mergeState(state, otherState.getHyperLogLog());
    }

    @CombineFunction
    public static void combineState(BooleanDistinctState state, BooleanDistinctState otherState) {
        state.setByte((byte)(state.getByte() | otherState.getByte()));
    }

    @OutputFunction(value="bigint")
    public static void evaluateFinal(@AggregationState HyperLogLogState state, BlockBuilder out) {
        HyperLogLog hyperLogLog = state.getHyperLogLog();
        if (hyperLogLog == null) {
            BigintType.BIGINT.writeLong(out, 0L);
        } else {
            BigintType.BIGINT.writeLong(out, hyperLogLog.cardinality());
        }
    }

    @OutputFunction(value="bigint")
    public static void evaluateFinal(BooleanDistinctState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, (long)Integer.bitCount(state.getByte()));
    }
}

