/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.operator.aggregation.FloatingPointBitsConverterUtil;
import com.facebook.presto.operator.aggregation.StatisticalDigest;
import com.facebook.presto.operator.aggregation.StatisticalDigestAggregationFunction;
import com.facebook.presto.operator.aggregation.StatisticalDigestFactory;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestState;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestStateFactory;
import com.facebook.presto.operator.scalar.QuantileDigestFunctions;
import com.facebook.presto.spi.function.SqlFunctionVisibility;

public final class QuantileDigestAggregationFunction
extends StatisticalDigestAggregationFunction {
    public static final QuantileDigestAggregationFunction QDIGEST_AGG = new QuantileDigestAggregationFunction(TypeSignature.parseTypeSignature((String)"V"));
    public static final QuantileDigestAggregationFunction QDIGEST_AGG_WITH_WEIGHT = new QuantileDigestAggregationFunction(TypeSignature.parseTypeSignature((String)"V"), TypeSignature.parseTypeSignature((String)"bigint"));
    public static final QuantileDigestAggregationFunction QDIGEST_AGG_WITH_WEIGHT_AND_ERROR = new QuantileDigestAggregationFunction(TypeSignature.parseTypeSignature((String)"V"), TypeSignature.parseTypeSignature((String)"bigint"), TypeSignature.parseTypeSignature((String)"double"));
    public static final String NAME = "qdigest_agg";

    private QuantileDigestAggregationFunction(TypeSignature ... typeSignatures) {
        super(NAME, "qdigest", StatisticalDigestStateFactory.createQuantileDigestFactory(), SqlFunctionVisibility.PUBLIC, typeSignatures);
    }

    public String getDescription() {
        return "Returns a qdigest from the set of reals, bigints, doubles";
    }

    public static void inputDouble(StatisticalDigestState state, double value, long weight, double parameter) {
        QuantileDigestAggregationFunction.inputBigint(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, parameter);
    }

    public static void inputReal(StatisticalDigestState state, long value, long weight, double accuracy) {
        QuantileDigestAggregationFunction.inputBigint(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, accuracy);
    }

    public static void inputBigint(StatisticalDigestState state, long value, long weight, double accuracy) {
        StatisticalDigest digest = QuantileDigestAggregationFunction.getOrCreateQuantileDigest(state, QuantileDigestFunctions.verifyAccuracy(accuracy));
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, QuantileDigestFunctions.verifyWeight(weight));
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    private static StatisticalDigest getOrCreateQuantileDigest(StatisticalDigestState state, double parameter) {
        StatisticalDigest digest = state.getStatisticalDigest();
        if (digest == null) {
            digest = StatisticalDigestFactory.createStatisticalQuantileDigest(new QuantileDigest(parameter));
            state.setStatisticalDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        return digest;
    }
}

