/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.operator.aggregation.DoubleHistogramAggregation;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import java.util.Map;

@AggregationFunction(value="numeric_histogram")
public class RealHistogramAggregation {
    private RealHistogramAggregation() {
    }

    @InputFunction
    public static void add(@AggregationState DoubleHistogramAggregation.State state, @SqlType(value="bigint") long buckets, @SqlType(value="real") long value, @SqlType(value="double") double weight) {
        DoubleHistogramAggregation.add(state, buckets, Float.intBitsToFloat((int)value), weight);
    }

    @InputFunction
    public static void add(@AggregationState DoubleHistogramAggregation.State state, @SqlType(value="bigint") long buckets, @SqlType(value="real") long value) {
        RealHistogramAggregation.add(state, buckets, value, 1.0);
    }

    @CombineFunction
    public static void merge(@AggregationState DoubleHistogramAggregation.State state, @AggregationState DoubleHistogramAggregation.State other) {
        DoubleHistogramAggregation.merge(state, other);
    }

    @OutputFunction(value="map(real,real)")
    public static void output(@AggregationState DoubleHistogramAggregation.State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            Map<Double, Double> value = state.get().getBuckets();
            BlockBuilder entryBuilder = out.beginBlockEntry();
            for (Map.Entry<Double, Double> entry : value.entrySet()) {
                RealType.REAL.writeLong(entryBuilder, (long)Float.floatToRawIntBits(entry.getKey().floatValue()));
                RealType.REAL.writeLong(entryBuilder, (long)Float.floatToRawIntBits(entry.getValue().floatValue()));
            }
            out.closeEntry();
        }
    }
}

