/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentHistogram;
import com.facebook.presto.operator.aggregation.state.StringApproximateMostFrequentStateFactory;
import com.facebook.presto.operator.aggregation.state.StringApproximateMostFrequentStateSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateMetadata;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;

@AggregationFunction(value="approx_most_frequent")
public final class VarcharApproximateMostFrequent {
    private VarcharApproximateMostFrequent() {
    }

    @InputFunction
    public static void input(@AggregationState State state, @SqlType(value="bigint") long buckets, @SqlType(value="varchar") Slice value, @SqlType(value="bigint") long capacity) {
        ApproximateMostFrequentHistogram<Slice> histogram = state.get();
        if (histogram == null) {
            Failures.checkCondition(buckets >= 2L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "approx_most_frequent bucket count must be greater than one", new Object[0]);
            histogram = new ApproximateMostFrequentHistogram<Slice>(Math.toIntExact(buckets), Math.toIntExact(capacity), StringApproximateMostFrequentStateSerializer::serializeBucket, StringApproximateMostFrequentStateSerializer::deserializeBucket);
            state.set(histogram);
        }
        histogram.add(value);
    }

    @CombineFunction
    public static void combine(@AggregationState State state, @AggregationState State otherState) {
        ApproximateMostFrequentHistogram<Slice> otherHistogram = otherState.get();
        ApproximateMostFrequentHistogram<Slice> histogram = state.get();
        if (histogram == null) {
            state.set(otherHistogram);
        } else {
            histogram.merge(otherHistogram);
        }
    }

    @OutputFunction(value="map(varchar,bigint)")
    public static void output(@AggregationState State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            BlockBuilder entryBuilder = out.beginBlockEntry();
            state.get().forEachBucket((key, value) -> {
                VarcharType.VARCHAR.writeSlice(entryBuilder, key);
                BigintType.BIGINT.writeLong(entryBuilder, value);
            });
            out.closeEntry();
        }
    }

    @AccumulatorStateMetadata(stateSerializerClass=StringApproximateMostFrequentStateSerializer.class, stateFactoryClass=StringApproximateMostFrequentStateFactory.class)
    public static interface State
    extends AccumulatorState {
        public ApproximateMostFrequentHistogram<Slice> get();

        public void set(ApproximateMostFrequentHistogram<Slice> var1);
    }
}

