/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.EntropyCalculations;
import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramStateStrategyUtils;
import com.facebook.presto.operator.aggregation.fixedhistogram.FixedDoubleBreakdownHistogram;
import com.google.common.collect.Streams;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Map;
import java.util.stream.Collectors;

public class FixedHistogramJacknifeStateStrategy
implements DifferentialEntropyStateStrategy {
    private final FixedDoubleBreakdownHistogram histogram;

    public FixedHistogramJacknifeStateStrategy(long bucketCount, double min, double max) {
        FixedHistogramStateStrategyUtils.validateParameters(bucketCount, min, max);
        this.histogram = new FixedDoubleBreakdownHistogram(Math.toIntExact(bucketCount), min, max);
    }

    private FixedHistogramJacknifeStateStrategy(FixedDoubleBreakdownHistogram histogram) {
        this.histogram = histogram;
    }

    private FixedHistogramJacknifeStateStrategy(FixedHistogramJacknifeStateStrategy other) {
        this.histogram = other.histogram.clone();
    }

    @Override
    public void validateParameters(long bucketCount, double sample, double weight, double min, double max) {
        FixedHistogramStateStrategyUtils.validateParameters(this.histogram.getBucketCount(), this.histogram.getMin(), this.histogram.getMax(), bucketCount, sample, weight, min, max);
    }

    @Override
    public void mergeWith(DifferentialEntropyStateStrategy other) {
        this.histogram.mergeWith(((FixedHistogramJacknifeStateStrategy)other).histogram);
    }

    @Override
    public void add(double value, double weight) {
        this.histogram.add(value, weight);
    }

    @Override
    public double getTotalPopulationWeight() {
        return Streams.stream(this.histogram.iterator()).mapToDouble(FixedDoubleBreakdownHistogram.Bucket::getWeight).sum();
    }

    @Override
    public double calculateEntropy() {
        Map<Double, Double> bucketWeights = Streams.stream(this.histogram.iterator()).collect(Collectors.groupingBy(FixedDoubleBreakdownHistogram.Bucket::getLeft, Collectors.summingDouble(e -> (double)e.getCount() * e.getWeight())));
        double sumWeight = bucketWeights.values().stream().mapToDouble(Double::doubleValue).sum();
        if (sumWeight == 0.0) {
            return Double.NaN;
        }
        long n = Streams.stream(this.histogram.iterator()).mapToLong(FixedDoubleBreakdownHistogram.Bucket::getCount).sum();
        double sumWeightLogWeight = bucketWeights.values().stream().mapToDouble(w -> w == 0.0 ? 0.0 : w * Math.log(w)).sum();
        double entropy = (double)n * EntropyCalculations.calculateEntropyFromHistogramAggregates(this.histogram.getWidth(), sumWeight, sumWeightLogWeight);
        for (FixedDoubleBreakdownHistogram.Bucket bucketWeight : this.histogram) {
            double weight = bucketWeights.get(bucketWeight.getLeft());
            if (!(weight > 0.0)) continue;
            entropy -= FixedHistogramJacknifeStateStrategy.getHoldOutEntropy(n, bucketWeight.getRight() - bucketWeight.getLeft(), sumWeight, sumWeightLogWeight, weight, bucketWeight.getWeight(), bucketWeight.getCount());
        }
        return entropy;
    }

    private static double getHoldOutEntropy(long n, double width, double sumW, double sumWeightLogWeight, double bucketWeight, double entryWeight, long entryMultiplicity) {
        double holdoutBucketWeight = Math.max(bucketWeight - entryWeight, 0.0);
        double holdoutSumWeight = sumW - bucketWeight + holdoutBucketWeight;
        double holdoutSumWeightLogWeight = sumWeightLogWeight - FixedHistogramStateStrategyUtils.getXLogX(bucketWeight) + FixedHistogramStateStrategyUtils.getXLogX(holdoutBucketWeight);
        double holdoutEntropy = (double)(entryMultiplicity * (n - 1L)) * EntropyCalculations.calculateEntropyFromHistogramAggregates(width, holdoutSumWeight, holdoutSumWeightLogWeight) / (double)n;
        return holdoutEntropy;
    }

    @Override
    public long getEstimatedSize() {
        return this.histogram.estimatedInMemorySize();
    }

    @Override
    public int getRequiredBytesForSpecificSerialization() {
        return this.histogram.getRequiredBytesForSerialization();
    }

    public static FixedHistogramJacknifeStateStrategy deserialize(SliceInput input) {
        FixedDoubleBreakdownHistogram histogram = FixedDoubleBreakdownHistogram.deserialize(input);
        return new FixedHistogramJacknifeStateStrategy(histogram);
    }

    @Override
    public void serialize(SliceOutput out) {
        this.histogram.serialize(out);
    }

    @Override
    public DifferentialEntropyStateStrategy clone() {
        return new FixedHistogramJacknifeStateStrategy(this);
    }

    @Override
    public DifferentialEntropyStateStrategy cloneEmpty() {
        return new FixedHistogramJacknifeStateStrategy(this.histogram.getBucketCount(), this.histogram.getMin(), this.histogram.getMax());
    }
}

