/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;

public class NullableLongStateSerializer
implements AccumulatorStateSerializer<NullableLongState> {
    public Type getSerializedType() {
        return BigintType.BIGINT;
    }

    public void serialize(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BigintType.BIGINT.writeLong(out, state.getLong());
        }
    }

    public void deserialize(Block block, int index, NullableLongState state) {
        state.setNull(false);
        state.setLong(BigintType.BIGINT.getLong(block, index));
    }
}

