/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.annotations;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.operator.annotations.ImplementationDependency;
import com.facebook.presto.operator.annotations.OperatorImplementationDependency;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.type.Constraint;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class FunctionsParserHelper {
    private static final Set<OperatorType> COMPARABLE_TYPE_OPERATORS = ImmutableSet.of((Object)OperatorType.EQUAL, (Object)OperatorType.NOT_EQUAL, (Object)OperatorType.HASH_CODE);
    private static final Set<OperatorType> ORDERABLE_TYPE_OPERATORS = ImmutableSet.of((Object)OperatorType.LESS_THAN, (Object)OperatorType.LESS_THAN_OR_EQUAL, (Object)OperatorType.GREATER_THAN, (Object)OperatorType.GREATER_THAN_OR_EQUAL, (Object)OperatorType.BETWEEN);

    private FunctionsParserHelper() {
    }

    public static boolean containsAnnotation(Annotation[] annotations, Predicate<Annotation> predicate) {
        return Arrays.stream(annotations).anyMatch(predicate);
    }

    public static boolean containsImplementationDependencyAnnotation(Annotation[] annotations) {
        return FunctionsParserHelper.containsAnnotation(annotations, ImplementationDependency::isImplementationDependencyAnnotation);
    }

    public static List<TypeVariableConstraint> createTypeVariableConstraints(Iterable<TypeParameter> typeParameters, List<ImplementationDependency> dependencies) {
        HashSet<String> orderableRequired = new HashSet<String>();
        HashSet<String> comparableRequired = new HashSet<String>();
        for (ImplementationDependency dependency : dependencies) {
            OperatorType operator;
            if (!(dependency instanceof OperatorImplementationDependency) || (operator = ((OperatorImplementationDependency)dependency).getOperator()) == OperatorType.CAST) continue;
            Set argumentTypes = (Set)((OperatorImplementationDependency)dependency).getArgumentTypes().stream().map(TypeSignature::getBase).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument((argumentTypes.size() == 1 ? 1 : 0) != 0, (Object)"Operator dependency must only have arguments of a single type");
            String argumentType = (String)Iterables.getOnlyElement((Iterable)argumentTypes);
            if (COMPARABLE_TYPE_OPERATORS.contains(operator)) {
                comparableRequired.add(argumentType);
            }
            if (!ORDERABLE_TYPE_OPERATORS.contains(operator)) continue;
            orderableRequired.add(argumentType);
        }
        ImmutableList.Builder typeVariableConstraints = ImmutableList.builder();
        for (TypeParameter typeParameter : typeParameters) {
            String name = typeParameter.value();
            if (orderableRequired.contains(name)) {
                typeVariableConstraints.add((Object)new TypeVariableConstraint(name, false, true, null, typeParameter.boundedBy()));
                continue;
            }
            if (comparableRequired.contains(name)) {
                typeVariableConstraints.add((Object)new TypeVariableConstraint(name, true, false, null, typeParameter.boundedBy()));
                continue;
            }
            typeVariableConstraints.add((Object)new TypeVariableConstraint(name, false, false, null, typeParameter.boundedBy()));
        }
        return typeVariableConstraints.build();
    }

    public static void validateSignaturesCompatibility(Optional<Signature> signatureOld, Signature signatureNew) {
        if (!signatureOld.isPresent()) {
            return;
        }
        Preconditions.checkArgument((boolean)signatureOld.get().equals((Object)signatureNew), (String)"Implementations with type parameters must all have matching signatures. %s does not match %s", (Object)signatureOld.get(), (Object)signatureNew);
    }

    @SafeVarargs
    public static Set<Method> findPublicStaticMethods(Class<?> clazz, Class<? extends Annotation> ... includedAnnotations) {
        return FunctionsParserHelper.findPublicStaticMethods(clazz, (Set<Class<? extends Annotation>>)ImmutableSet.copyOf(Arrays.asList(includedAnnotations)), (Set<Class<? extends Annotation>>)ImmutableSet.of());
    }

    public static Set<Method> findPublicStaticMethods(Class<?> clazz, Set<Class<? extends Annotation>> includedAnnotations, Set<Class<? extends Annotation>> excludedAnnotations) {
        return FunctionsParserHelper.findMethods(clazz.getMethods(), method -> Preconditions.checkArgument((Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) ? 1 : 0) != 0, (String)"Annotated method [%s] must be static and public", (Object)method.getName()), includedAnnotations, excludedAnnotations);
    }

    @SafeVarargs
    public static Set<Method> findPublicMethods(Class<?> clazz, Class<? extends Annotation> ... includedAnnotations) {
        return FunctionsParserHelper.findPublicMethods(clazz, (Set<Class<? extends Annotation>>)ImmutableSet.copyOf(Arrays.asList(includedAnnotations)), (Set<Class<? extends Annotation>>)ImmutableSet.of());
    }

    public static Set<Method> findPublicMethods(Class<?> clazz, Set<Class<? extends Annotation>> includedAnnotations, Set<Class<? extends Annotation>> excludedAnnotations) {
        return FunctionsParserHelper.findMethods(clazz.getDeclaredMethods(), method -> Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (Object)"Annotated method [%s] must be public"), includedAnnotations, excludedAnnotations);
    }

    public static Set<Method> findMethods(Method[] allMethods, Consumer<Method> methodChecker, Set<Class<? extends Annotation>> includedAnnotations, Set<Class<? extends Annotation>> excludedAnnotations) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Method method : allMethods) {
            boolean included = false;
            boolean excluded = false;
            block1: for (Annotation annotation : method.getAnnotations()) {
                for (Class<? extends Annotation> annotationClass : excludedAnnotations) {
                    if (!annotationClass.isInstance(annotation)) continue;
                    excluded = true;
                    break;
                }
                if (excluded) break;
                if (included) continue;
                for (Class<? extends Annotation> annotationClass : includedAnnotations) {
                    if (!annotationClass.isInstance(annotation)) continue;
                    included = true;
                    continue block1;
                }
            }
            if (!included || excluded) continue;
            methodChecker.accept(method);
            methods.add((Object)method);
        }
        return methods.build();
    }

    public static Optional<Constructor<?>> findConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Preconditions.checkArgument((constructors.length <= 1 ? 1 : 0) != 0, (Object)"Class [%s] must have no more than 1 public constructor");
        if (constructors.length == 0) {
            return Optional.empty();
        }
        return Optional.of(constructors[0]);
    }

    public static Set<String> parseLiteralParameters(Method method) {
        LiteralParameters literalParametersAnnotation = method.getAnnotation(LiteralParameters.class);
        if (literalParametersAnnotation == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])literalParametersAnnotation.value());
    }

    public static boolean containsLegacyNullable(Annotation[] annotations) {
        return Arrays.stream(annotations).map(Annotation::annotationType).map(Class::getName).anyMatch(name -> name.equals(Nullable.class.getName()));
    }

    public static boolean isPrestoAnnotation(Annotation annotation) {
        return ImplementationDependency.isImplementationDependencyAnnotation(annotation) || annotation instanceof SqlType || annotation instanceof SqlNullable || annotation instanceof IsNull;
    }

    public static Optional<String> parseDescription(AnnotatedElement base, AnnotatedElement override) {
        Optional<String> overrideDescription = FunctionsParserHelper.parseDescription(override);
        if (overrideDescription.isPresent()) {
            return overrideDescription;
        }
        return FunctionsParserHelper.parseDescription(base);
    }

    public static Optional<String> parseDescription(AnnotatedElement base) {
        Description description = base.getAnnotation(Description.class);
        return description == null ? Optional.empty() : Optional.of(description.value());
    }

    public static List<LongVariableConstraint> parseLongVariableConstraints(Method inputFunction) {
        return (List)Stream.of(inputFunction.getAnnotationsByType(Constraint.class)).map(annotation -> new LongVariableConstraint(annotation.variable(), annotation.expression())).collect(ImmutableList.toImmutableList());
    }

    public static Map<String, Class<?>> getDeclaredSpecializedTypeParameters(Method method, Set<TypeParameter> typeParameters) {
        HashMap specializedTypeParameters = new HashMap();
        TypeParameterSpecialization[] typeParameterSpecializations = (TypeParameterSpecialization[])method.getAnnotationsByType(TypeParameterSpecialization.class);
        ImmutableSet typeParameterNames = (ImmutableSet)typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet());
        for (TypeParameterSpecialization specialization : typeParameterSpecializations) {
            Preconditions.checkArgument((boolean)typeParameterNames.contains((Object)specialization.name()), (String)"%s does not match any declared type parameters (%s) [%s]", (Object)specialization.name(), typeParameters, (Object)method);
            Class existingSpecialization = (Class)specializedTypeParameters.get(specialization.name());
            Preconditions.checkArgument((existingSpecialization == null || existingSpecialization.equals(specialization.nativeContainerType()) ? 1 : 0) != 0, (String)"%s has conflicting specializations %s and %s [%s]", (Object)specialization.name(), (Object)existingSpecialization, (Object)specialization.nativeContainerType(), (Object)method);
            specializedTypeParameters.put(specialization.name(), specialization.nativeContainerType());
        }
        return specializedTypeParameters;
    }
}

