/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.operator.MoreByteArrays;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class MapBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 5;
    @VisibleForTesting
    static final int HASH_MULTIPLIER = 2;
    private static final int POSITION_SIZE_WITH_HASHTABLE = 13;
    private static final String NAME = "MAP";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlockEncodingBuffer.class).instanceSize();
    private byte[] hashTablesBuffer;
    private int hashTableBufferIndex;
    private int estimatedHashTableBufferMaxCapacity;
    private boolean noHashTables;
    private byte[] offsetsBuffer;
    private int offsetsBufferIndex;
    private int estimatedOffsetBufferMaxCapacity;
    private int[] offsets;
    private int lastOffset;
    private ColumnarMap columnarMap;
    private final AbstractBlockEncodingBuffer keyBuffers;
    private final AbstractBlockEncodingBuffer valueBuffers;

    public MapBlockEncodingBuffer(DecodedBlockNode decodedBlockNode, ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
        this.keyBuffers = (AbstractBlockEncodingBuffer)MapBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlockNode.getChildren().get(0), bufferAllocator, true);
        this.valueBuffers = (AbstractBlockEncodingBuffer)MapBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlockNode.getChildren().get(1), bufferAllocator, true);
    }

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        int i = 0;
        while (i < this.positionCount) {
            int n = i++;
            serializedRowSizes[n] = serializedRowSizes[n] + 5;
        }
        int[] offsetsCopy = Arrays.ensureCapacity(null, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        try {
            System.arraycopy(this.offsets, 0, offsetsCopy, 0, this.positionCount + 1);
            this.keyBuffers.accumulateSerializedRowSizes(offsetsCopy, this.positionCount, serializedRowSizes);
            System.arraycopy(this.offsets, 0, offsetsCopy, 0, this.positionCount + 1);
            this.valueBuffers.accumulateSerializedRowSizes(offsetsCopy, this.positionCount, serializedRowSizes);
        }
        finally {
            this.bufferAllocator.returnArray(offsetsCopy);
        }
    }

    @Override
    public void setNextBatch(int positionsOffset, int batchSize) {
        this.positionsOffset = positionsOffset;
        this.batchSize = batchSize;
        this.flushed = false;
        if (this.positionCount == 0) {
            return;
        }
        int beginOffset = this.offsets[positionsOffset];
        int endOffset = this.offsets[positionsOffset + batchSize];
        this.keyBuffers.setNextBatch(beginOffset, endOffset - beginOffset);
        this.valueBuffers.setNextBatch(beginOffset, endOffset - beginOffset);
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendNulls();
        this.appendOffsets();
        this.appendHashTables();
        this.keyBuffers.appendDataInBatch();
        this.valueBuffers.appendDataInBatch();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        MapBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        this.keyBuffers.serializeTo(output);
        this.valueBuffers.serializeTo(output);
        if (this.hashTableBufferIndex == 0) {
            output.appendInt(-1);
        } else {
            output.appendInt(this.lastOffset * 2);
            output.appendBytes(this.hashTablesBuffer, 0, this.hashTableBufferIndex);
        }
        output.writeInt(this.bufferedPositionCount);
        output.appendInt(0);
        if (this.offsetsBufferIndex > 0) {
            output.appendBytes(this.offsetsBuffer, 0, this.offsetsBufferIndex);
        }
        this.serializeNullsTo(output);
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.offsetsBufferIndex = 0;
        this.lastOffset = 0;
        this.hashTableBufferIndex = 0;
        this.noHashTables = false;
        this.flushed = true;
        this.resetNullsBuffer();
        this.keyBuffers.resetBuffers();
        this.valueBuffers.resetBuffers();
    }

    @Override
    public void noMoreBatches() {
        this.valueBuffers.noMoreBatches();
        this.keyBuffers.noMoreBatches();
        if (this.flushed) {
            if (this.hashTablesBuffer != null) {
                this.bufferAllocator.returnArray(this.hashTablesBuffer);
                this.hashTablesBuffer = null;
            }
            if (this.offsetsBuffer != null) {
                this.bufferAllocator.returnArray(this.offsetsBuffer);
                this.offsetsBuffer = null;
            }
        }
        super.noMoreBatches();
        if (this.offsets != null) {
            this.bufferAllocator.returnArray(this.offsets);
            this.offsets = null;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyBuffers.getRetainedSizeInBytes() + this.valueBuffers.getRetainedSizeInBytes();
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4) + this.keyBuffers.getSerializedSizeInBytes() + this.valueBuffers.getSerializedSizeInBytes() + 4L + (long)this.hashTableBufferIndex + 4L + (long)this.offsetsBufferIndex + 4L + this.getNullsBufferSerializedSizeInBytes();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("estimatedHashTableBufferMaxCapacity", this.estimatedHashTableBufferMaxCapacity).add("hashTablesBufferCapacity", this.hashTablesBuffer == null ? 0 : this.hashTablesBuffer.length).add("hashTableBufferIndex", this.hashTableBufferIndex).add("estimatedOffsetBufferMaxCapacity", this.estimatedOffsetBufferMaxCapacity).add("offsetsBufferCapacity", this.offsetsBuffer == null ? 0 : this.offsetsBuffer.length).add("offsetsBufferIndex", this.offsetsBufferIndex).add("offsetsCapacity", this.offsets == null ? 0 : this.offsets.length).add("lastOffset", this.lastOffset).add("keyBuffers", (Object)this.keyBuffers).add("valueBuffers", (Object)this.valueBuffers).toString();
    }

    @Override
    protected int getEstimatedValueBufferMaxCapacity() {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    int getEstimatedOffsetBufferMaxCapacity() {
        return this.estimatedOffsetBufferMaxCapacity;
    }

    @VisibleForTesting
    int getEstimatedHashTableBufferMaxCapacity() {
        return this.estimatedHashTableBufferMaxCapacity;
    }

    @VisibleForTesting
    BlockEncodingBuffer getKeyBuffers() {
        return this.keyBuffers;
    }

    @VisibleForTesting
    BlockEncodingBuffer getValueBuffers() {
        return this.valueBuffers;
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode, int partitionBufferCapacity, double decodedBlockPageSizeFraction) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        decodedBlockNode = this.mapPositionsToNestedBlock(decodedBlockNode);
        this.columnarMap = (ColumnarMap)decodedBlockNode.getDecodedBlock();
        this.decodedBlock = this.columnarMap.getNullCheckBlock();
        long estimatedSerializedSizeInBytes = decodedBlockNode.getEstimatedSerializedSizeInBytes();
        long keyBufferEstimatedSerializedSizeInBytes = decodedBlockNode.getChildren().get(0).getEstimatedSerializedSizeInBytes();
        long valueBufferEstimatedSerializedSizeInBytes = decodedBlockNode.getChildren().get(1).getEstimatedSerializedSizeInBytes();
        double targetBufferSize = (double)partitionBufferCapacity * decodedBlockPageSizeFraction * (double)(estimatedSerializedSizeInBytes - keyBufferEstimatedSerializedSizeInBytes - valueBufferEstimatedSerializedSizeInBytes) / (double)estimatedSerializedSizeInBytes;
        this.estimatedHashTableBufferMaxCapacity = MapBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 8, 13);
        this.setEstimatedNullsBufferMaxCapacity(MapBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 1, 13));
        this.estimatedOffsetBufferMaxCapacity = MapBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 4, 13);
        this.populateNestedPositions();
        this.keyBuffers.setupDecodedBlockAndMapPositions(decodedBlockNode.getChildren().get(0), partitionBufferCapacity, decodedBlockPageSizeFraction * (double)keyBufferEstimatedSerializedSizeInBytes / (double)estimatedSerializedSizeInBytes);
        this.valueBuffers.setupDecodedBlockAndMapPositions(decodedBlockNode.getChildren().get(1), partitionBufferCapacity, decodedBlockPageSizeFraction * (double)valueBufferEstimatedSerializedSizeInBytes / (double)estimatedSerializedSizeInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        if (this.positionCount == 0) {
            return;
        }
        int lastOffset = positionOffsets[0];
        for (int i = 0; i < positionCount; ++i) {
            int offset = positionOffsets[i + 1];
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + 5 * (offset - lastOffset);
            lastOffset = offset;
            positionOffsets[i + 1] = this.offsets[offset];
        }
        int[] offsetsCopy = Arrays.ensureCapacity(null, (int)(positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        try {
            System.arraycopy(positionOffsets, 0, offsetsCopy, 0, positionCount + 1);
            this.keyBuffers.accumulateSerializedRowSizes(positionOffsets, positionCount, serializedRowSizes);
            this.valueBuffers.accumulateSerializedRowSizes(offsetsCopy, positionCount, serializedRowSizes);
        }
        finally {
            this.bufferAllocator.returnArray(offsetsCopy);
        }
    }

    private void populateNestedPositions() {
        int i;
        this.keyBuffers.resetPositions();
        this.valueBuffers.resetPositions();
        if (this.positionCount == 0) {
            return;
        }
        this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        this.offsets[0] = 0;
        int[] positions = this.getPositions();
        for (i = 0; i < this.positionCount; ++i) {
            int position = positions[i];
            this.offsets[i + 1] = this.offsets[i] + this.columnarMap.getOffset(position + 1) - this.columnarMap.getOffset(position);
        }
        this.keyBuffers.ensurePositionsCapacity(this.offsets[this.positionCount]);
        this.valueBuffers.ensurePositionsCapacity(this.offsets[this.positionCount]);
        for (i = 0; i < this.positionCount; ++i) {
            int beginOffset = this.columnarMap.getOffset(positions[i]);
            int currentRowSize = this.offsets[i + 1] - this.offsets[i];
            this.keyBuffers.appendPositionRange(beginOffset, currentRowSize);
            this.valueBuffers.appendPositionRange(beginOffset, currentRowSize);
        }
    }

    private void appendOffsets() {
        this.offsetsBuffer = Arrays.ensureCapacity((byte[])this.offsetsBuffer, (int)(this.offsetsBufferIndex + this.batchSize * Unsafe.ARRAY_INT_INDEX_SCALE), (int)this.estimatedOffsetBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int baseOffset = this.lastOffset - this.offsets[this.positionsOffset];
        for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            this.offsetsBufferIndex = UncheckedByteArrays.setIntUnchecked(this.offsetsBuffer, this.offsetsBufferIndex, this.offsets[i + 1] + baseOffset);
        }
        this.lastOffset = this.offsets[this.positionsOffset + this.batchSize] + baseOffset;
    }

    private void appendHashTables() {
        if (this.noHashTables) {
            return;
        }
        int[] hashTables = this.columnarMap.getHashTables();
        if (hashTables == null) {
            this.noHashTables = true;
            this.hashTableBufferIndex = 0;
            return;
        }
        int hashTablesSize = (this.offsets[this.positionsOffset + this.batchSize] - this.offsets[this.positionsOffset]) * 2;
        this.hashTablesBuffer = Arrays.ensureCapacity((byte[])this.hashTablesBuffer, (int)(this.hashTableBufferIndex + hashTablesSize * Unsafe.ARRAY_INT_INDEX_SCALE), (int)this.estimatedHashTableBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int[] positions = this.getPositions();
        for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            int position = positions[i];
            int beginOffset = this.columnarMap.getAbsoluteOffset(position);
            int endOffset = this.columnarMap.getAbsoluteOffset(position + 1);
            this.hashTableBufferIndex = MoreByteArrays.setInts(this.hashTablesBuffer, this.hashTableBufferIndex, hashTables, beginOffset * 2, (endOffset - beginOffset) * 2);
        }
    }
}

