/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

public class PartitionedOutputInfo
implements Mergeable<PartitionedOutputInfo>,
OperatorInfo {
    private final long rowsAdded;
    private final long pagesAdded;
    private final long outputBufferPeakMemoryUsage;

    @JsonCreator
    public PartitionedOutputInfo(@JsonProperty(value="rowsAdded") long rowsAdded, @JsonProperty(value="pagesAdded") long pagesAdded, @JsonProperty(value="outputBufferPeakMemoryUsage") long outputBufferPeakMemoryUsage) {
        this.rowsAdded = rowsAdded;
        this.pagesAdded = pagesAdded;
        this.outputBufferPeakMemoryUsage = outputBufferPeakMemoryUsage;
    }

    @JsonProperty
    public long getRowsAdded() {
        return this.rowsAdded;
    }

    @JsonProperty
    public long getPagesAdded() {
        return this.pagesAdded;
    }

    @JsonProperty
    public long getOutputBufferPeakMemoryUsage() {
        return this.outputBufferPeakMemoryUsage;
    }

    @Override
    public PartitionedOutputInfo mergeWith(PartitionedOutputInfo other) {
        return new PartitionedOutputInfo(this.rowsAdded + other.rowsAdded, this.pagesAdded + other.pagesAdded, Math.max(this.outputBufferPeakMemoryUsage, other.outputBufferPeakMemoryUsage));
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowsAdded", this.rowsAdded).add("pagesAdded", this.pagesAdded).add("outputBufferPeakMemoryUsage", this.outputBufferPeakMemoryUsage).toString();
    }
}

