/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.JsonCastException;
import com.facebook.presto.util.JsonUtil;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class JsonToMapCast
extends SqlOperator {
    public static final JsonToMapCast JSON_TO_MAP = new JsonToMapCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToMapCast.class, "toMap", MapType.class, JsonUtil.BlockBuilderAppender.class, JsonUtil.BlockBuilderAppender.class, SqlFunctionProperties.class, Slice.class);

    private JsonToMapCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"K"), (Object)Signature.typeVariable((String)"V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"json")));
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        MapType mapType = (MapType)functionAndTypeManager.getParameterizedType("map", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        Failures.checkCondition(JsonUtil.canCastFromJson((Type)mapType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", mapType);
        JsonUtil.BlockBuilderAppender keyAppender = JsonUtil.BlockBuilderAppender.createBlockBuilderAppender(mapType.getKeyType());
        JsonUtil.BlockBuilderAppender valueAppender = JsonUtil.BlockBuilderAppender.createBlockBuilderAppender(mapType.getValueType());
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(mapType).bindTo(keyAppender).bindTo(valueAppender);
        return new BuiltInScalarFunctionImplementation(true, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block toMap(MapType mapType, JsonUtil.BlockBuilderAppender keyAppender, JsonUtil.BlockBuilderAppender valueAppender, SqlFunctionProperties properties, Slice json) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JsonUtil.JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block = null;
                return block;
            }
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonCastException(String.format("Expected a json object, but got %s", jsonParser.getText()));
            }
            BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
            BlockBuilder singleMapBlockBuilder = mapBlockBuilder.beginBlockEntry();
            JsonUtil.HashTable hashTable = new JsonUtil.HashTable(mapType.getKeyType(), singleMapBlockBuilder);
            int position = 0;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                keyAppender.append(jsonParser, singleMapBlockBuilder);
                jsonParser.nextToken();
                valueAppender.append(jsonParser, singleMapBlockBuilder);
                if (!hashTable.addIfAbsent(position)) {
                    throw new JsonCastException("Duplicate keys are not allowed");
                }
                position += 2;
            }
            if (jsonParser.nextToken() != null) {
                throw new JsonCastException(String.format("Unexpected trailing token: %s", jsonParser.getText()));
            }
            mapBlockBuilder.closeEntry();
            Block block = mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
            return block;
        }
        catch (PrestoException | JsonCastException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", mapType, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", mapType, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }
}

