/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.lambda.LambdaFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapZipWithFunction
extends SqlScalarFunction {
    public static final MapZipWithFunction MAP_ZIP_WITH_FUNCTION = new MapZipWithFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapZipWithFunction.class, "mapZipWith", Type.class, Type.class, Type.class, MapType.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Object.class, Block.class, Block.class, MapZipWithLambda.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(MapZipWithFunction.class, "createState", MapType.class);

    private MapZipWithFunction() {
        super(new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"map_zip_with"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"K"), (Object)Signature.typeVariable((String)"V1"), (Object)Signature.typeVariable((String)"V2"), (Object)Signature.typeVariable((String)"V3")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V3)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V1)"), (Object)TypeSignature.parseTypeSignature((String)"map(K,V2)"), (Object)TypeSignature.parseTypeSignature((String)"function(K,V1,V2,V3)")), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return false;
    }

    public String getDescription() {
        return "merge two maps into a single map by applying the lambda function to the pair of values with the same key";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type inputValueType1 = boundVariables.getTypeVariable("V1");
        Type inputValueType2 = boundVariables.getTypeVariable("V2");
        Type outputValueType = boundVariables.getTypeVariable("V3");
        Type outputMapType = functionAndTypeManager.getParameterizedType("map", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)outputValueType.getTypeSignature())));
        MethodHandle keyNativeHashCode = functionAndTypeManager.getBuiltInScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes(keyType))).getMethodHandle();
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeEquals = functionAndTypeManager.getBuiltInScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(keyType, keyType))).getMethodHandle();
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyBlockEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        return new BuiltInScalarFunctionImplementation(false, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(MapZipWithLambda.class)), METHOD_HANDLE.bindTo(keyType).bindTo(inputValueType1).bindTo(inputValueType2).bindTo(outputMapType).bindTo(keyNativeHashCode).bindTo(keyBlockNativeEquals).bindTo(keyBlockHashCode), Optional.of(STATE_FACTORY.bindTo(outputMapType)));
    }

    public static Object createState(MapType mapType) {
        return new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    public static Block mapZipWith(Type keyType, Type leftValueType, Type rightValueType, MapType outputMapType, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode, Object state, Block leftBlock, Block rightBlock, MapZipWithLambda function) {
        Object key;
        SingleMapBlock leftMapBlock = (SingleMapBlock)leftBlock;
        SingleMapBlock rightMapBlock = (SingleMapBlock)rightBlock;
        Type outputValueType = outputMapType.getValueType();
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder mapBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        boolean[] keyFound = new boolean[rightMapBlock.getPositionCount()];
        for (int leftKeyPosition = 0; leftKeyPosition < leftMapBlock.getPositionCount(); leftKeyPosition += 2) {
            Object outputValue;
            int rightValuePosition;
            key = TypeUtils.readNativeValue((Type)keyType, (Block)leftMapBlock, (int)leftKeyPosition);
            Object leftValue = TypeUtils.readNativeValue((Type)leftValueType, (Block)leftMapBlock, (int)(leftKeyPosition + 1));
            try {
                rightValuePosition = rightMapBlock.seekKey(key, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
            }
            catch (NotSupportedException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
            }
            Object rightValue = null;
            if (rightValuePosition != -1) {
                rightValue = TypeUtils.readNativeValue((Type)rightValueType, (Block)rightMapBlock, (int)rightValuePosition);
                keyFound[rightValuePosition / 2] = true;
            }
            try {
                outputValue = function.apply(key, leftValue, rightValue);
            }
            catch (Throwable throwable) {
                mapBlockBuilder.closeEntry();
                pageBuilder.declarePosition();
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            keyType.appendTo((Block)leftMapBlock, leftKeyPosition, blockBuilder);
            TypeUtils.writeNativeValue((Type)outputValueType, (BlockBuilder)blockBuilder, (Object)outputValue);
        }
        for (int rightKeyPosition = 0; rightKeyPosition < rightMapBlock.getPositionCount(); rightKeyPosition += 2) {
            Object outputValue;
            if (keyFound[rightKeyPosition / 2]) continue;
            key = TypeUtils.readNativeValue((Type)keyType, (Block)rightMapBlock, (int)rightKeyPosition);
            Object rightValue = TypeUtils.readNativeValue((Type)rightValueType, (Block)rightMapBlock, (int)(rightKeyPosition + 1));
            try {
                outputValue = function.apply(key, null, rightValue);
            }
            catch (Throwable throwable) {
                mapBlockBuilder.closeEntry();
                pageBuilder.declarePosition();
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            keyType.appendTo((Block)rightMapBlock, rightKeyPosition, blockBuilder);
            TypeUtils.writeNativeValue((Type)outputValueType, (BlockBuilder)blockBuilder, (Object)outputValue);
        }
        mapBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return outputMapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }

    @FunctionalInterface
    public static interface MapZipWithLambda
    extends LambdaFunctionInterface {
        public Object apply(Object var1, Object var2, Object var3);
    }
}

