/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.ParametricImplementationsGroup;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarHeader;
import com.facebook.presto.operator.scalar.annotations.ParametricScalarImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;

public class ParametricScalar
extends SqlScalarFunction {
    private final ScalarHeader details;
    private final ParametricImplementationsGroup<ParametricScalarImplementation> implementations;

    public ParametricScalar(Signature signature, ScalarHeader details, ParametricImplementationsGroup<ParametricScalarImplementation> implementations) {
        super(signature);
        this.details = Objects.requireNonNull(details);
        this.implementations = Objects.requireNonNull(implementations);
    }

    public SqlFunctionVisibility getVisibility() {
        return this.details.getVisibility();
    }

    public boolean isDeterministic() {
        return this.details.isDeterministic();
    }

    @Override
    public boolean isCalledOnNullInput() {
        return this.details.isCalledOnNullInput();
    }

    public String getDescription() {
        return this.details.getDescription().isPresent() ? this.details.getDescription().get() : "";
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<ParametricScalarImplementation> getImplementations() {
        return this.implementations;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Optional<BuiltInScalarFunctionImplementation> scalarFunctionImplementation;
        Signature boundSignature = SignatureBinder.applyBoundVariables(this.getSignature(), boundVariables, arity);
        if (this.implementations.getExactImplementations().containsKey(boundSignature)) {
            ParametricScalarImplementation implementation = this.implementations.getExactImplementations().get(boundSignature);
            Optional<BuiltInScalarFunctionImplementation> scalarFunctionImplementation2 = implementation.specialize(boundSignature, boundVariables, functionAndTypeManager);
            Failures.checkCondition(scalarFunctionImplementation2.isPresent(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Exact implementation of %s do not match expected java types.", boundSignature.getNameSuffix()), new Object[0]);
            return scalarFunctionImplementation2.get();
        }
        BuiltInScalarFunctionImplementation selectedImplementation = null;
        for (ParametricScalarImplementation implementation : this.implementations.getSpecializedImplementations()) {
            scalarFunctionImplementation = implementation.specialize(boundSignature, boundVariables, functionAndTypeManager);
            if (!scalarFunctionImplementation.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", this.getSignature(), boundVariables.getTypeVariables());
            selectedImplementation = scalarFunctionImplementation.get();
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        for (ParametricScalarImplementation implementation : this.implementations.getGenericImplementations()) {
            scalarFunctionImplementation = implementation.specialize(boundSignature, boundVariables, functionAndTypeManager);
            if (!scalarFunctionImplementation.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", this.getSignature(), boundVariables.getTypeVariables());
            selectedImplementation = scalarFunctionImplementation.get();
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", boundVariables, this.getSignature()));
    }
}

