/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.sql.gen.lambda.LambdaFunctionInterface;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SplitToMapFunction {
    private SplitToMapFunction() {
    }

    private static Block splitToMap(PageBuilder pageBuilder, Type mapType, Slice string, Slice entryDelimiter, Slice keyValueDelimiter, Optional<DuplicateKeyResolutionLambda> function) {
        Failures.checkCondition(entryDelimiter.length() > 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "entryDelimiter is empty", new Object[0]);
        Failures.checkCondition(keyValueDelimiter.length() > 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "keyValueDelimiter is empty", new Object[0]);
        Failures.checkCondition(!entryDelimiter.equals((Object)keyValueDelimiter), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "entryDelimiter and keyValueDelimiter must not be the same", new Object[0]);
        Objects.requireNonNull(pageBuilder, "pageBuilder is null");
        HashMap<Slice, Slice> map = new HashMap<Slice, Slice>();
        int entryStart = 0;
        while (entryStart < string.length()) {
            Slice value;
            Slice key;
            int entryEnd = string.indexOf(entryDelimiter, entryStart);
            Slice keyValuePair = entryEnd >= 0 ? string.slice(entryStart, entryEnd - entryStart) : string.slice(entryStart, string.length() - entryStart);
            int keyEnd = keyValuePair.indexOf(keyValueDelimiter);
            if (keyEnd >= 0) {
                int valueStart = keyEnd + keyValueDelimiter.length();
                key = keyValuePair.slice(0, keyEnd);
                value = keyValuePair.slice(valueStart, keyValuePair.length() - valueStart);
                if (value.indexOf(keyValueDelimiter) >= 0) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key-value delimiter must appear exactly once in each entry. Bad input: '" + keyValuePair.toStringUtf8() + "'");
                }
                if (map.containsKey(key)) {
                    if (!function.isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Duplicate keys (%s) are not allowed. Specifying a lambda to resolve conflicts can avoid this error", key.toStringUtf8()));
                    }
                    value = function.get().apply(key, (Slice)map.get(key), value);
                }
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key-value delimiter must appear exactly once in each entry. Bad input: '" + keyValuePair.toStringUtf8() + "'");
            }
            map.put(key, value);
            if (entryEnd < 0) break;
            entryStart = entryEnd + entryDelimiter.length();
        }
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder singleMapBlockBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry entry : map.entrySet()) {
            VarcharType.VARCHAR.writeSlice(singleMapBlockBuilder, (Slice)entry.getKey());
            VarcharType.VARCHAR.writeSlice(singleMapBlockBuilder, (Slice)entry.getValue());
        }
        blockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return (Block)mapType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }

    @FunctionalInterface
    public static interface DuplicateKeyResolutionLambda
    extends LambdaFunctionInterface {
        public Slice apply(Slice var1, Slice var2, Slice var3);
    }

    @Description(value="creates a map using entryDelimiter and keyValueDelimiter along with a lambda to handle duplicate keys")
    @ScalarFunction(value="split_to_map")
    public static class ResolveDuplicateKeys {
        private final PageBuilder pageBuilder;

        public ResolveDuplicateKeys(@TypeParameter(value="map<varchar,varchar>") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map<varchar,varchar>")
        public Block split(@TypeParameter(value="map<varchar,varchar>") Type mapType, @SqlType(value="varchar") Slice string, @SqlType(value="varchar") Slice entryDelimiter, @SqlType(value="varchar") Slice keyValueDelimiter, @SqlType(value="function(varchar, varchar, varchar, varchar)") DuplicateKeyResolutionLambda function) {
            return SplitToMapFunction.splitToMap(this.pageBuilder, mapType, string, entryDelimiter, keyValueDelimiter, Optional.of(function));
        }
    }

    @Description(value="creates a map using entryDelimiter and keyValueDelimiter")
    @ScalarFunction(value="split_to_map")
    public static class FailOnDuplicateKeys {
        private final PageBuilder pageBuilder;

        public FailOnDuplicateKeys(@TypeParameter(value="map<varchar,varchar>") Type mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        @SqlType(value="map<varchar,varchar>")
        public Block split(@TypeParameter(value="map<varchar,varchar>") Type mapType, @SqlType(value="varchar") Slice string, @SqlType(value="varchar") Slice entryDelimiter, @SqlType(value="varchar") Slice keyValueDelimiter) {
            return SplitToMapFunction.splitToMap(this.pageBuilder, mapType, string, entryDelimiter, keyValueDelimiter, Optional.empty());
        }
    }
}

