/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.server.ForWorkerInfo;
import com.facebook.presto.spi.NodeState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/worker")
@RolesAllowed(value={"admin"})
public class WorkerResource {
    private final InternalNodeManager nodeManager;
    private final HttpClient httpClient;

    @Inject
    public WorkerResource(InternalNodeManager nodeManager, @ForWorkerInfo HttpClient httpClient) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    @GET
    @Path(value="{nodeId}/status")
    public Response getStatus(@PathParam(value="nodeId") String nodeId) {
        return this.proxyJsonResponse(nodeId, "v1/status");
    }

    @GET
    @Path(value="{nodeId}/thread")
    public Response getThreads(@PathParam(value="nodeId") String nodeId) {
        return this.proxyJsonResponse(nodeId, "v1/thread");
    }

    private Response proxyJsonResponse(String nodeId, String workerPath) {
        Set<InternalNode> nodes = this.nodeManager.getNodes(NodeState.ACTIVE);
        InternalNode node = nodes.stream().filter(n -> n.getNodeIdentifier().equals(nodeId)).findFirst().orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        Request request = Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath(workerPath).build()).build();
        InputStream responseStream = (InputStream)this.httpClient.execute(request, (ResponseHandler)new StreamingJsonResponseHandler());
        return Response.ok((Object)responseStream, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static class StreamingJsonResponseHandler
    implements ResponseHandler<InputStream, RuntimeException> {
        private StreamingJsonResponseHandler() {
        }

        public InputStream handleException(Request request, Exception exception) {
            throw new RuntimeException("Request to worker failed", exception);
        }

        public InputStream handle(Request request, com.facebook.airlift.http.client.Response response) {
            try {
                if ("application/json".equals(response.getHeader("Content-Type"))) {
                    return response.getInputStream();
                }
                throw new RuntimeException("Response received was not of type application/json");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read response from worker", e);
            }
        }
    }
}

